package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackTridentTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidTridentTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_6880;
import net.minecraft.class_7893;
import java.util.List;
import java.util.function.Predicate;

import static com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys.getEnchantmentHolder;

public class TaskTridentAttack implements IRangedAttackTask {
    public static final class_2960 UID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "trident_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8547.method_7854();
    }

    @Nullable
    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138((target) -> !hasTrident(maid) || farAway(target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        class_7893<EntityMaid> maidAttackStrafingTask = new MaidAttackTridentTask();
        class_7893<EntityMaid> shootTargetTask = new MaidTridentTargetTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, moveToTargetTask),
                Pair.of(5, maidAttackStrafingTask),
                Pair.of(5, shootTargetTask)
        );
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138((target) -> !hasTrident(maid) || farAway(target, maid));
        class_7893<EntityMaid> shootTargetTask = new MaidTridentTargetTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, shootTargetTask)
        );
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.TRIDENT_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (hasTrident(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014(searchRange);
            } else {
                return maid.method_5829().method_1014(searchRange);
            }
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return MaidConfig.TRIDENT_RANGE.get();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        class_1799 tridentItem = shooter.method_6047().method_7972();

        // 去除忠诚附魔，不然三叉戟返回来是发现主人不是玩家，就翻脸不认人了不给捡了
        class_6880<class_1887> loyalty = getEnchantmentHolder(shooter.field_6002.method_30349(), class_1893.field_9120);
        if (class_1890.method_8225(loyalty, tridentItem) > 0) {
            class_1890.method_57531(tridentItem, mutable -> mutable.method_57547(loyalty, 0));
        }

        // TODO：伤害和好感度挂钩
        class_1685 thrownTrident = new class_1685(shooter.field_6002, shooter, tridentItem);
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();

        // 依据距离调整三叉戟速度和不准确度
        float distance = shooter.method_5739(target);
        float velocity = class_3532.method_15363(distance / 10f, 1.6f, 3.2f);
        float inaccuracy = 1 - class_3532.method_15363(distance / 100f, 0, 0.9f);

        // 射出的三叉戟忽略重力，从而能让女仆百发百中
        thrownTrident.method_5875(true);
        thrownTrident.method_7485(x, y, z, velocity, inaccuracy);
        // 不允许任何人捡起
        thrownTrident.field_7572 = class_1665.class_1666.field_7594;

        shooter.method_6047().method_7970(1, shooter, class_1304.field_6173);
        shooter.field_6002.method_8649(thrownTrident);
        shooter.method_5783(class_3417.field_15001.comp_349(), 1.0F, 1.0F);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList(Pair.of("has_trident", this::hasTrident));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return stack.method_7909() instanceof class_1835;
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739(target) > this.searchRadius(maid);
    }

    private boolean hasTrident(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1835;
    }
}