package com.github.tartaricacid.touhoulittlemaid.init;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootTableBuilder;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.loot.LootTableTypeCondition;
import com.github.tartaricacid.touhoulittlemaid.loot.RandomBoardStateFunction;
import com.github.tartaricacid.touhoulittlemaid.loot.SetTankCountFunction;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_120;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_55;
import net.minecraft.class_7923;
import net.minecraft.class_83;

public class InitLootModifier {
    public static final class_2960 UNKNOWN_LOOT_TABLE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "unknown_loot_table");

    private static final class_2960 LAST = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "last");

    public static final class_5342 LOOT_TABLE_TYPE = registerCondition("loot_table_type", new class_5342(LootTableTypeCondition.CODEC));

    public static final class_5339<? extends class_120> SET_TANK_COUNT_FUNCTION =
            registerFunction("set_tank_count", new class_5339<>(SetTankCountFunction.CODEC));

    public static final class_5339<? extends class_120> BOARD_STATE_RANDOMLY =
            registerFunction("board_state_randomly", new class_5339<>(RandomBoardStateFunction.CODEC));

    private static class_5342 registerCondition(String id, class_5342 condition) {
        return class_2378.method_10230(class_7923.field_41135, class_2960.method_60655(TouhouLittleMaid.MOD_ID, id), condition);
    }

    private static <T extends class_120> class_5339<T> registerFunction(String id, class_5339<T> function) {
        return class_2378.method_10230(class_7923.field_41134, class_2960.method_60655(TouhouLittleMaid.MOD_ID, id), function);
    }

    public static void init() {
        // Global Modifier
        LootTableEvents.MODIFY.register((key, builder, source, provider) -> {
                    if (key.method_29177().toString().startsWith("minecraft:chests"))
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.CHEST_POWER_POINT)));

                    if (key == class_39.field_850)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SPAWN_BONUS)));
                    if (key == class_39.field_17109)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.NORMAL_BAUBLE)));
                    if (key == class_39.field_16751)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RANDOM_BOARD_STATE)));
                    if (key == class_39.field_885)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RARE_BAUBLE)));
                    if (key == class_39.field_803)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.RARE_BAUBLE)));
                    if (key == class_39.field_484)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.VERY_RARE_BAUBLE)));
                    if (key == class_39.field_356)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.FURNACE_OR_CRAFTING_TABLE_BACKPACK)));
                    if (key == class_39.field_472)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.NORMAL_BACKPACK)));
                    if (key == class_39.field_615)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.TANK_BACKPACK)));
                    if (key == class_39.field_842)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.ENDER_CHEST_BACKPACK)));
                    if (key == class_39.field_683)
                        builder.method_336(class_55.method_347()
                                .method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS))
                                .method_351(class_83.method_428(LootTableGenerator.RANDOM_BOARD_STATE))
                        );
                    if (key == class_39.field_38438)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS)));
                    if (key == class_39.field_24046)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_LESS)));
                    if (key == class_39.field_274)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.SHRINE_MORE)));

                    if (key == class_39.field_251)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.MAID_BURIED_TREASURE)));

                    if (key == class_39.field_16593)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT)));
                    if (key == class_39.field_484)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT)));

                    if (key == class_39.field_266)
                        builder.method_336(class_55.method_347().method_351(class_83.method_428(LootTableGenerator.FISHING_POWER_POINT)));
                }
        );

        LootTableEvents.MODIFY.addPhaseOrdering(Event.DEFAULT_PHASE, LAST);
        LootTableEvents.MODIFY.register(LAST,
                (key, builder, source, provider) -> ((ILootTableBuilder) builder).tlm$setId(key.method_29177())
        );
    }
}
