package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidBackpackChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitCapabilities;
import com.mojang.datafixers.util.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

import javax.annotation.Nonnull;

import static net.minecraft.class_1723.*;


public abstract class MaidMainContainer extends AbstractMaidContainer {
    protected static final int PLAYER_INVENTORY_SIZE = 36;
    private static final class_2960 EMPTY_MAINHAND_SLOT = class_2960.method_60654("item/empty_slot_sword");
    private static final class_2960 EMPTY_BACK_SHOW_SLOT = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "slot/empty_back_show_slot");
    private static final class_2960[] TEXTURE_EMPTY_SLOTS = new class_2960[]{field_21672, field_21671, field_21670, field_21669};
    private static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    public MaidMainContainer(class_3917<?> type, int id, class_1661 inventory, int entityId) {
        super(type, id, inventory, entityId);
        if (maid != null) {
            this.addMaidArmorInv();
            this.addMaidHandInv();
            this.addMainDefaultInv();
            this.addBackpackInv(inventory);
        }
    }

    protected void addMaidHandInv() {
        IItemHandler handler = InitCapabilities.MAID_HAND.getNullable(maid);
        if (handler == null) {
            return;
        }
        method_7621(new SlotItemHandler(handler, 0, 87, 77) {
            @Override
            @Environment(EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of(field_21668, EMPTY_MAINHAND_SLOT);
            }
        });
        method_7621(new SlotItemHandler(handler, 1, 121, 77) {
            @Override
            @Environment(EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of(field_21668, field_21673);
            }
        });
    }

    protected void addMaidArmorInv() {
        IItemHandler handler = InitCapabilities.MAID_ARMOR.getNullable(maid);
        if (handler != null) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; j++) {
                    final class_1304 equipmentSlot = SLOT_IDS[2 * i + j];
                    method_7621(new SlotItemHandler(handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i) {
                        @Override
                        public int method_7675() {
                            return 1;
                        }

                        @Override
                        public boolean method_7680(@Nonnull class_1799 stack) {
                            return maid != null && maid.method_32326(stack) == equipmentSlot && stack.method_7909().method_31568();
                        }

                        @Override
                        public boolean method_7674(class_1657 playerIn) {
                            class_1799 itemstack = this.method_7677();
                            boolean curseEnchant = !itemstack.method_7960() && !playerIn.method_7337() && class_1890.method_60138(itemstack, class_9636.field_51551);
                            return !curseEnchant && super.method_7674(playerIn);
                        }

                        @Override
                        @Environment(EnvType.CLIENT)
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, TEXTURE_EMPTY_SLOTS[equipmentSlot.method_5927()]);
                        }
                    });
                }
            }
        }
    }

    protected void addMainDefaultInv() {
        // 默认背包
        for (int i = 0; i < 6; i++) {
            method_7621(new BackpackSlot(maid, i, 143 + 18 * i, 37));
            // 最后一格给予特殊图标
            if (i == 5) {
                method_7621(new BackpackSlot(maid, i, 143 + 18 * i, 37) {
                    @Override
                    public Pair<class_2960, class_2960> method_7679() {
                        return Pair.of(field_21668, EMPTY_BACK_SHOW_SLOT);
                    }
                });
            }
        }
    }

    protected abstract void addBackpackInv(class_1661 inventory);

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();

            if (index < PLAYER_INVENTORY_SIZE) {
                if (!this.method_7616(stack2, PLAYER_INVENTORY_SIZE, this.field_7761.size(), false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(stack2, 0, PLAYER_INVENTORY_SIZE, true)) {
                return class_1799.field_8037;
            }

            if (stack2.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }

            if (stack2.method_7947() == stack1.method_7947()) {
                return class_1799.field_8037;
            }

            slot.method_7667(player, stack2);
            // 触发 Shift 点击取出事件
            if (slot instanceof ITriggerSlotChange slotChange) {
                slotChange.onShiftTakeoff(player, stack1);
            }

            // 用来修正护甲值不变化的问题
            if (PLAYER_INVENTORY_SIZE <= index && index < PLAYER_INVENTORY_SIZE + 4) {
                class_1304 equipmentSlot = SLOT_IDS[index - PLAYER_INVENTORY_SIZE];
                maid.method_30122(equipmentSlot, stack1);
            }
            // 还有主副手
            if (PLAYER_INVENTORY_SIZE + 4 <= index && index < PLAYER_INVENTORY_SIZE + 6) {
                int slotIndex = index - PLAYER_INVENTORY_SIZE - 4;
                class_1304 equipmentSlot = slotIndex == 0 ? class_1304.field_6173 : class_1304.field_6171;
                maid.method_30124(equipmentSlot, stack1);
            }
        }
        return stack1;
    }

    public static class BackpackSlot extends SlotItemHandler implements ITriggerSlotChange {
        private final EntityMaid maid;

        public BackpackSlot(EntityMaid maid, int index, int xPosition, int yPosition) {
            super(maid.getMaidInv(), index, xPosition, yPosition);
            this.maid = maid;
        }

        @Override
        public void onShiftTakeoff(@Nullable class_1657 player, class_1799 stack) {
            if (!maid.field_6002.field_9236 && !stack.method_7960()) {
                MaidBackpackChangeEvent.TAKE_OFF.invoker().takeOff(new MaidBackpackChangeEvent.TakeOff(maid, stack));
            }
        }

        @Override
        public void method_7667(class_1657 player, class_1799 stack) {
            super.method_7667(player, stack);
            this.onShiftTakeoff(player, stack);
        }

        @Override
        public void method_53512(class_1799 stack) {
            super.method_53512(stack);
            if (!maid.field_6002.field_9236 && !stack.method_7960()) {
                MaidBackpackChangeEvent.PUT_ON.invoker().putOn(new MaidBackpackChangeEvent.PutOn(maid, stack));
            }
        }
    }
}
