package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidBaubleChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

public class BaubleContainer extends MaidMainContainer {
    public static final class_3917<BaubleContainer> TYPE = new ExtendedScreenHandlerType<>(BaubleContainer::new, class_9135.field_49675);

    public BaubleContainer(int id, class_1661 inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static class_3908 create(EntityMaid maid) {
        return new ExtendedScreenHandlerFactory<Integer>() {
            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

            @Override
            public Integer getScreenOpeningData(class_3222 player) {
                return maid.method_5628();
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_43470("Maid Bauble Container");
            }

            @Override
            public class_1703 createMenu(int index, class_1661 inventory, class_1657 player) {
                int entityId = maid.method_5628();
                return new BaubleContainer(index, inventory, entityId);
            }
        };
    }

    @Override
    protected void addMainDefaultInv() {
        // 留空，表示不添加女仆物品栏
    }

    @Override
    protected void addBackpackInv(class_1661 inventory) {
        // 0 级和 1 级：只有前两层
        // 2 级，前四层
        // 3 级及以上，全部开放
        int level = this.maid.getFavorabilityManager().getLevel();
        // 以防万一，检测是否越界
        int maxSize = maid.getMaidBauble().getSlots();

        for (int y = 0; y < 6; y++) {
            if (level <= 1 && y >= 2) {
                break;
            }
            if (level == 2 && y >= 4) {
                break;
            }
            for (int x = 0; x < 5; x++) {
                int index = x + y * 5;
                if (index >= maxSize) {
                    return;
                }
                method_7621(new BaubleSlot(maid, index, 152 + 18 * x, 45 + 18 * y));
            }
        }
    }

    public static class BaubleSlot extends SlotItemHandler implements ITriggerSlotChange {
        private final EntityMaid maid;

        public BaubleSlot(EntityMaid maid, int index, int xPosition, int yPosition) {
            super(maid.getMaidBauble(), index, xPosition, yPosition);
            this.maid = maid;
        }

        @Override
        public void onShiftTakeoff(@Nullable class_1657 player, class_1799 stack) {
            if (!maid.field_6002.field_9236 && !stack.method_7960()) {
                IMaidBauble bauble = BaubleManager.getBauble(stack);
                if (bauble != null) {
                    bauble.onTakeOff(maid, stack);
                    MaidBaubleChangeEvent.TAKE_OFF.invoker().takeOff(new MaidBaubleChangeEvent.TakeOff(maid, stack));
                }
            }
        }

        @Override
        public void method_7667(class_1657 player, class_1799 stack) {
            super.method_7667(player, stack);
            this.onShiftTakeoff(player, stack);
        }

        @Override
        public void method_53512(class_1799 stack) {
            super.method_53512(stack);
            if (!maid.field_6002.field_9236 && !stack.method_7960()) {
                IMaidBauble bauble = BaubleManager.getBauble(stack);
                if (bauble != null) {
                    bauble.onPutOn(maid, stack);
                    MaidBaubleChangeEvent.PUT_ON.invoker().putOn(new MaidBaubleChangeEvent.PutOn(maid, stack));
                }
            }
        }
    }
}