package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IItemRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_756;
import net.minecraft.class_9334;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Objects;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.*;

public class ItemChair extends class_1792 implements IItemRenderer {
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";

    @Environment(EnvType.CLIENT)
    @Override
    public class_756 getCustomRenderer() {
        return TileEntityItemStackChairRenderer.INSTANCE.get();
    }

    public ItemChair() {
        super((new class_1793()).method_7889(1));
    }

    public static Data getData(class_1799 stack) {
        if (stack.method_7909() == InitItems.CHAIR) {
            return Data.deserialization(stack);
        }
        return new Data(DEFAULT_MODEL_ID, 0f, true, false);
    }

    public static class_1799 setData(class_1799 stack, Data data) {
        if (stack.method_7909() == InitItems.CHAIR) {
            Data.serialization(stack, data);
        }
        return stack;
    }

    @Environment(EnvType.CLIENT)
    public static void fillItemCategory(class_1761.class_7704 items) {
        for (String key : CustomPackLoader.CHAIR_MODELS.getModelIdSet()) {
            float height = CustomPackLoader.CHAIR_MODELS.getModelMountedYOffset(key);
            boolean canRide = CustomPackLoader.CHAIR_MODELS.getModelTameableCanRide(key);
            boolean isNoGravity = CustomPackLoader.CHAIR_MODELS.getModelNoGravity(key);
            items.method_45420(setData(new class_1799(InitItems.CHAIR), new Data(key, height, canRide, isNoGravity)));
        }
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8038() != class_2350.field_11033) {
            class_1937 world = context.method_8045();
            class_2338 clickedPos = new class_1750(context).method_8037();
            class_238 boundingBox = EntityChair.TYPE.method_18386().method_30757(class_243.method_24955(clickedPos));
            if (world.method_18026(boundingBox) && world.method_8335(null, boundingBox).isEmpty()) {
                class_1799 stack = context.method_8041();
                if (world instanceof class_3218 serverWorld) {
                    EntityChair chair = getSpawnChair(serverWorld, context.method_8036(), stack, context.method_8037(), context.method_8044());
                    if (chair == null) {
                        return class_1269.field_5814;
                    }
                    world.method_8649(chair);
                    world.method_43128(null, chair.method_23317(), chair.method_23318(), chair.method_23321(), class_3417.field_15226, class_3419.field_15245, 0.75F, 0.8F);
                }
                stack.method_7934(1);
                return class_1269.method_29236(world.field_9236);
            }
        }
        return class_1269.field_5814;
    }

    @Nullable
    public static EntityChair getSpawnChair(class_3218 serverWorld, @Nullable class_1657 player, class_1799 stack, class_2338 pos, float rotation) {
        EntityChair chair = EntityChair.TYPE.method_5888(serverWorld, (e) -> {
            if (stack.method_57824(class_9334.field_49631) != null) {
                e.method_5665(stack.method_57824(class_9334.field_49631));
            }
        }, pos, class_3730.field_16465, true, true);
        if (chair != null) {
            addExtraData(player, stack, chair, rotation);
        }
        return chair;
    }

    private static void addExtraData(@Nullable class_1657 player, class_1799 stack, EntityChair chair, float rotation) {
        Data data = Data.deserialization(stack);
        chair.setModelId(data.modelId());
        chair.setMountedHeight(data.height());
        chair.setTameableCanRide(data.canRide());
        chair.method_5875(data.isNoGravity());
        chair.setOwner(player);
        float yaw = (float) class_3532.method_15375((class_3532.method_15393(rotation - 180) + 22.5F) / 45.0F) * 45.0F;
        chair.method_5808(chair.method_23317(), chair.method_23318(), chair.method_23321(), yaw, 0.0F);
        chair.method_5636(yaw);
        chair.method_5847(yaw);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            // 添加坐垫前缀，方便搜索
            class_5250 prefix = class_2561.method_43471("item.touhou_little_maid.chair.prefix");
            Data data = getData(stack);
            if (CustomPackLoader.CHAIR_MODELS.getInfo(data.modelId()).isPresent()) {
                String name = CustomPackLoader.CHAIR_MODELS.getInfo(data.modelId()).get().getName();
                return prefix.method_10852(ParseI18n.parse(name));
            }
        }
        return super.method_7864(stack);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.chair.place.desc").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.chair.destroy.desc").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.chair.gui.desc").method_27692(class_124.field_1080));
        // 调试模式，不加国际化
        if (flagIn.method_8035() && class_437.method_25442()) {
            Data data = Data.deserialization(stack);
            tooltip.add(class_2561.method_43470("Model Id: " + data.modelId()).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470("Mounted Height: " + data.height()).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470("Tameable Can Ride: " + data.canRide()).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470("Is No Gravity: " + data.isNoGravity()).method_27692(class_124.field_1080));
        }
    }

    public record Data(String modelId, float height, boolean canRide, boolean isNoGravity) {
        public static void serialization(class_1799 stack, Data data) {
            stack.method_57379(MODEL_ID_TAG, data.modelId());
            stack.method_57379(MOUNTED_HEIGHT_TAG, data.height());
            stack.method_57379(TAMEABLE_CAN_RIDE_TAG, data.canRide());
            stack.method_57379(IS_NO_GRAVITY_TAG, data.isNoGravity());
        }

        public static Data deserialization(class_1799 stack) {
            String modelId = Objects.requireNonNullElse(stack.method_57824(MODEL_ID_TAG), DEFAULT_MODEL_ID);
            float height = Objects.requireNonNullElse(stack.method_57824(MOUNTED_HEIGHT_TAG), 0f);
            boolean canRide = Objects.requireNonNullElse(stack.method_57824(TAMEABLE_CAN_RIDE_TAG), true);
            boolean isNoGravity = Objects.requireNonNullElse(stack.method_57824(IS_NO_GRAVITY_TAG), false);
            return new Data(modelId, height, canRide, isNoGravity);
        }
    }
}
