package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidWirelessIOEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WirelessIOBauble implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static class_1799 insertItemStacked(IItemHandler inventory, @Nonnull class_1799 stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        if (stack.method_7960()) {
            return stack;
        }
        if (!stack.method_7946()) {
            return insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (int i = 0; i < sizeInventory; i++) {
            class_1799 slot = inventory.getStackInSlot(i);
            if (slotConfig != null && i < slotConfig.size() && slotConfig.get(i)) {
                continue;
            }
            if (class_1799.method_31577(slot, stack) && !slot.method_7960() && slot.method_7946()) {
                stack = inventory.insertItem(i, stack, simulate);
                if (stack.method_7960()) {
                    break;
                }
            }
        }

        if (!stack.method_7960()) {
            for (int i = 0; i < sizeInventory; i++) {
                if (slotConfig != null && i < slotConfig.size() && slotConfig.get(i)) {
                    continue;
                }
                if (inventory.getStackInSlot(i).method_7960()) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if (stack.method_7960()) {
                        break;
                    }
                }
            }
        }

        return stack;
    }

    public static class_1799 insertItem(IItemHandler dest, @Nonnull class_1799 stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        if (stack.method_7960()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); i++) {
            if (slotConfig != null && i < slotConfig.size() && slotConfig.get(i)) {
                continue;
            }
            stack = dest.insertItem(i, stack, simulate);
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
        }
        return stack;
    }

    @Override
    public void onTick(EntityMaid maid, class_1799 baubleItem) {
        if (maid.field_6012 % 100 == 0 && !maid.guiOpening) {
            class_2338 bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.method_18413();
            if (maid.method_5649(bindingPos.method_10263(), bindingPos.method_10264(), bindingPos.method_10260()) > (maxDistance * maxDistance)) {
                return;
            }
            class_2586 te = maid.field_6002.method_8321(bindingPos);
            if (te == null) {
                return;
            }
            for (IChestType type : ChestManager.getAllChestTypes()) {
                if (!type.isChest(te)) {
                    continue;
                }
                int openCount = type.getOpenCount(maid.field_6002, bindingPos, te);
                if (openCount > 0) {
                    return;
                }
                //IItemHandler chestInv = maid.level.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null);
                Storage<ItemVariant> chestInv = ItemStorage.SIDED.find(maid.field_6002, te.method_11016(), te.method_11010(), te, null);
                if (chestInv != null) {
                    IItemHandler maidInv = maid.getAvailableInv(false);
                    boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                    boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                    List<Boolean> slotConfig = ItemWirelessIO.getSlotConfig(baubleItem);
                    List<Boolean> slotConfigData;
                    if (slotConfig != null) {
                        slotConfigData = new ArrayList<>(slotConfig);
                        slotConfigData.set(maidInv.getSlots() - 2, slotConfig.get(SLOT_NUM - 2));
                        slotConfigData.set(maidInv.getSlots() - 1, slotConfig.get(SLOT_NUM - 1));
                    } else {
                        slotConfigData = new ArrayList<>(Collections.nCopies(SLOT_NUM, false));
                    }
                    IItemHandler filterList = ItemWirelessIO.getFilterList(maid.method_56673(), baubleItem);

                    if (isMaidToChest) {
                        var event = new MaidWirelessIOEvent.MaidToChest(maid, maidInv, chestInv, filterList, isBlacklist, slotConfigData);
                        MaidWirelessIOEvent.MAID_TO_CHEST.invoker().post(event);
                        if (!event.isCanceled()) {
                            maidToChest(maidInv, chestInv, isBlacklist, filterList, slotConfigData);
                        }
                    } else {
                        var event = new MaidWirelessIOEvent.ChestToMaid(maid, maidInv, chestInv, filterList, isBlacklist, slotConfigData);
                        MaidWirelessIOEvent.CHEST_TO_MAID.invoker().post(event);
                        if (!event.isCanceled()) {
                            chestToMaid(chestInv, maidInv, isBlacklist, filterList, slotConfigData);
                        }
                    }
                }
                if (maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_WIRELESS_IO);
                }
                return;
            }
        }
    }

    private void maidToChest(IItemHandler maid, Storage<ItemVariant> chest, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (int i = 0; i < maid.getSlots(); i++) {
            if (i < slotConfig.size() && slotConfig.get(i)) {
                continue;
            }
            class_1799 maidInvItem = maid.getStackInSlot(i);
            if (maidInvItem.method_7960())
                continue;
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); j++) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984(maidInvItem, filterItem);
                if (isEqual) {
                    allowMove = !isBlacklist;
                    break;
                }
            }
            if (allowMove) {
                int beforeCount = maidInvItem.method_7947();
/*                ItemStack after = ItemHandlerHelper.insertItemStacked(chest, maidInvItem.copy(), false);
                int afterCount = after.getCount();
                // Sync Client & Server
                if (beforeCount != afterCount) {
                    maid.extractItem(i, beforeCount - afterCount, false);
                }*/
                try (Transaction transaction = Transaction.openOuter()) {
                    long inserted = chest.insert(ItemVariant.of(maidInvItem.method_7972()), beforeCount, transaction);
                    if (inserted > 0) {
                        maid.extractItem(i, (int) inserted, false);
                        transaction.commit();
                    }
                }
            }
        }
    }

    private void chestToMaid(Storage<ItemVariant> chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (StorageView<ItemVariant> view : chest.nonEmptyViews()) {
            ItemVariant chestInvStack = view.getResource();
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); j++) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984(chestInvStack.toStack(), filterItem);
                if (isEqual) {
                    allowMove = !isBlacklist;
                    break;
                }
            }
            if (allowMove) {
                int beforeCount = (int) view.getAmount();
                class_1799 after = insertItemStacked(maid, chestInvStack.toStack(beforeCount).method_7972(), false, slotConfig);
                int afterCount = after.method_7947();
                // Sync Client & Server
                if (beforeCount != afterCount) {
                    //chest.extractItem(i, beforeCount - afterCount, false);
                    try (Transaction transaction = Transaction.openOuter()) {
                        chest.extract(view.getResource(), beforeCount - afterCount, transaction);
                        transaction.commit();
                    }
                }
            }
        }
    }
}
