package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.github.tartaricacid.touhoulittlemaid.item.ItemBoardState;
import com.github.tartaricacid.touhoulittlemaid.util.WeightedPicker;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class RandomBoardStateFunction extends class_120 {
    public static final class_2960 ID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "board_state_randomly");
    public static final MapCodec<RandomBoardStateFunction> CODEC = RecordCodecBuilder.mapCodec(
            instance -> method_53344(instance).and(
                    Codec.STRING.listOf().fieldOf("tags").forGetter(f -> f.tags)
            ).apply(instance, RandomBoardStateFunction::new)
    );

    /**
     * 会选择的残局所具有的 tag
     */
    private final List<String> tags;

    protected RandomBoardStateFunction(List<class_5341> predicates, List<String> tags) {
        super(predicates);
        this.tags = tags;
    }

    public static RandomBoardStateFunction.Builder create() {
        return new RandomBoardStateFunction.Builder();
    }


    private boolean checkTags(BoardStateRecord record) {
        for (String tag : tags) {
            if (record.tags().contains(tag)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected class_1799 method_522(class_1799 stack, class_47 context) {
        List<BoardStateRecord> records = BoardStateData.getRecordsByItem(stack);
        if (records.isEmpty()) {
            return stack;
        }
        if (this.tags.isEmpty()) {
            return stack;
        }
        List<BoardStateRecord> matchedRecords = records.stream().filter(this::checkTags).toList();
        if (matchedRecords.isEmpty()) {
            return stack;
        }
        BoardStateRecord selected = WeightedPicker.pickRandom(matchedRecords, BoardStateRecord::weight);
        if (selected == null) {
            return stack;
        }
        BoardStateRecord.Display display = selected.display();
        ItemBoardState.setState(stack, selected.data(), display.description(), display.author());
        return stack;
    }

    @Override
    public class_5339<? extends class_120> method_29321() {
        return InitLootModifier.BOARD_STATE_RANDOMLY;
    }

    public static class Builder extends class_120.class_121<RandomBoardStateFunction.Builder> {
        private final List<String> tags = Lists.newArrayList();

        @Override
        protected Builder method_523() {
            return this;
        }

        public RandomBoardStateFunction.Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        @Override
        public class_117 method_515() {
            return new RandomBoardStateFunction(this.method_526(), this.tags);
        }
    }
}