package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;

import java.util.List;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.TANK_BACKPACK_TAG;

public class SetTankCountFunction extends class_120 {
    public static MapCodec<SetTankCountFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> method_53344(instance)
            .and(instance.group(
                    class_2960.field_25139.fieldOf("fluid_id").forGetter(f -> f.fluidId),
                    Codec.LONG.fieldOf("count").forGetter(f -> f.count)
            )).apply(instance, SetTankCountFunction::new));

    private final class_2960 fluidId;
    private final long count;

    public SetTankCountFunction(List<class_5341> predicates, class_2960 fluidId, long count) {
        super(predicates);
        this.fluidId = fluidId;
        this.count = count;
    }

    @Override
    public @NotNull class_5339<? extends class_120> method_29321() {
        return InitLootModifier.SET_TANK_COUNT_FUNCTION;
    }

    @Override
    protected @NotNull class_1799 method_522(class_1799 stack, @NotNull class_47 context) {
        class_2487 tags = stack.method_57824(TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new class_2487();
        }
        SingleFluidStorage tank = SingleFluidStorage.withFixedCapacity(TankBackpackData.CAPACITY, () -> {
        });
        FluidVariant fluidStack = FluidVariant.of(class_7923.field_41173.method_10223(this.fluidId), class_9326.field_49588);
        try (Transaction transaction = Transaction.openOuter()) {
            tank.insert(fluidStack, count, transaction);
            transaction.commit();
            tank.writeNbt(tags, context.method_299().method_30349());
            stack.method_57379(InitDataComponent.TANK_BACKPACK_TAG, tags);
            return stack;
        }
    }

    public static class Builder extends class_120.class_121<SetTankCountFunction.Builder> {
        private final class_3611 fluid;
        private final int bucketCount;

        public Builder(class_3611 fluid, int bucketCount) {
            this.fluid = fluid;
            this.bucketCount = bucketCount;
        }

        @Override
        protected @NotNull Builder method_523() {
            return this;
        }

        @Override
        public @NotNull class_117 method_515() {
            class_2960 key = class_7923.field_41173.method_10221(fluid);
            return new SetTankCountFunction(this.method_526(), key, bucketCount * FluidConstants.BUCKET);
        }
    }
}