package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4965;

@Mixin(class_4965.class)
public class FishingHookPredicateMixin {
    @Shadow
    @Final
    private Optional<Boolean> inOpenWater;

    @Inject(method = "matches(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;)Z", at = @At("RETURN"), cancellable = true)
    private void matches(class_1297 entity, class_3218 level, class_243 position, CallbackInfoReturnable<Boolean> cir) {
        if (this.inOpenWater.isPresent() && entity instanceof MaidFishingHook fishingHook) {
            cir.setReturnValue(this.inOpenWater.get() == fishingHook.isOpenWaterFishing());
        }
    }
}