package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record GomokuClientPackage(class_2338 pos, List<byte[]> chessData, Point point,
                                  int count) implements class_8710 {
    public static final class_8710.class_9154<GomokuClientPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("gomoku_to_client"));
    public static final class_9139<ByteBuf, List<byte[]>> BYTE_BUF_LIST_STREAM_CODEC = class_9135.method_57991(
            ArrayList::new,
            class_9135.field_48987,
            15
    );
    public static final class_9139<ByteBuf, GomokuClientPackage> STREAM_CODEC = class_9139.method_56905(
            class_2338.field_48404,
            GomokuClientPackage::pos,
            BYTE_BUF_LIST_STREAM_CODEC,
            GomokuClientPackage::chessData,
            Point.POINT_STREAM_CODEC,
            GomokuClientPackage::point,
            class_9135.field_48550,
            GomokuClientPackage::count,
            GomokuClientPackage::new
    );

    public GomokuClientPackage(class_2338 pos, byte[][] chessData, Point point, int count) {
        this(pos, Arrays.stream(chessData).toList(), point, count);
    }

    public static void handle(GomokuClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> CompletableFuture.runAsync(() -> onHandle(message), class_156.method_18349()));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(GomokuClientPackage message) {
        Point aiPoint = MaidGomokuAI.getService(message.count).getPoint(message.chessData.toArray(new byte[15][]), message.point);
        int time = (int) (Math.random() * 1250) + 250;
        try {
            Thread.sleep(time);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        class_310.method_1551().method_5382(() -> ClientPlayNetworking.send(new GomokuServerPackage(message.pos, aiPoint)));
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
