package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record GomokuServerPackage(class_2338 pos, Point point) implements class_8710 {
    public static final class_8710.class_9154<GomokuServerPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("gomoku_to_server"));
    public static final class_9139<ByteBuf, GomokuServerPackage> STREAM_CODEC = class_9139.method_56435(
            class_2338.field_48404,
            GomokuServerPackage::pos,
            Point.POINT_STREAM_CODEC,
            GomokuServerPackage::point,
            GomokuServerPackage::new
    );

    public static void handle(GomokuServerPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1937 level = sender.field_6002;
            if (!level.method_8477(message.pos)) {
                return;
            }
            if (level.method_8321(message.pos) instanceof TileEntityGomoku gomoku) {
                Statue statue = gomoku.getStatue();
                if (statue != Statue.IN_PROGRESS || gomoku.isPlayerTurn() || gomoku.getChessCounter() <= 0) {
                    return;
                }
                Point aiPoint = message.point;
                gomoku.setChessData(aiPoint.x, aiPoint.y, aiPoint.type);
                gomoku.setStatue(MaidGomokuAI.getStatue(gomoku.getChessData(), aiPoint));
                statue = gomoku.getStatue();
                if (level instanceof class_3218 serverLevel && serverLevel.method_14190(gomoku.getSitId()) instanceof EntitySit sit && sit.method_31483() instanceof EntityMaid maid) {
                    maid.method_6104(class_1268.field_5808);
                    if (statue == Statue.WIN) {
                        maid.getGameRecordManager().markStatue(true);
                    }
                }
                level.method_8396(null, message.pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
                if (statue == Statue.IN_PROGRESS) {
                    gomoku.setPlayerTurn(true);
                }
                gomoku.refresh();
            }
        });
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
