package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

/**
 * 用于同步客户端播放动画的消息
 * 目前只包含拾取雪球的动画
 */
public record MaidAnimationPackage(int maidId, int animationId) implements class_8710 {
    public static final int NONE = 0;
    public static final int PICK_UP_SNOWBALL = 1;
    public static final int SWF_AIM = 2;
    public static final int SWF_RELOAD = 3;
    public static final int SWF_FIRE = 4;

    public static final class_8710.class_9154<MaidAnimationPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("maid_animation"));
    public static final class_9139<class_9129, MaidAnimationPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550, MaidAnimationPackage::maidId,
            class_9135.field_48550, MaidAnimationPackage::animationId,
            MaidAnimationPackage::new
    );

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static MaidAnimationPackage pickUpSnowball(EntityMaid maid) {
        // 播放丢雪球动画之前，先禁止女仆移动
        // 标记服务端事件
        maid.animationId = PICK_UP_SNOWBALL;
        maid.animationRecordTime = System.currentTimeMillis();
        // 返回消息
        return new MaidAnimationPackage(maid.method_5628(), PICK_UP_SNOWBALL);
    }

    public static void handle(MaidAnimationPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> handle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void handle(MaidAnimationPackage message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (level.method_8469(message.maidId) instanceof EntityMaid maid) {
            maid.animationId = message.animationId;
            maid.animationRecordTime = System.currentTimeMillis();
            maid.shouldReset = true;
        }
    }
}