package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidConfigManager;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record MaidSubConfigPackage(int id, MaidConfigManager.SyncNetwork syncNetwork) implements class_8710 {
    public static final class_8710.class_9154<MaidSubConfigPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("maid_sub_config"));
    public static final class_9139<ByteBuf, MaidSubConfigPackage> STREAM_CODEC = new class_9139<>() {
        @Override
        public void encode(ByteBuf buffer, MaidSubConfigPackage message) {
            class_2540 buf = new class_2540(buffer);
            buf.method_10804(message.id);
            MaidConfigManager.SyncNetwork.encode(message.syncNetwork, buf);
        }

        @Override
        public MaidSubConfigPackage decode(ByteBuf buffer) {
            class_2540 buf = new class_2540(buffer);
            int entityId = buf.method_10816();
            MaidConfigManager.SyncNetwork network = MaidConfigManager.SyncNetwork.decode(buf);
            return new MaidSubConfigPackage(entityId, network);
        }
    };

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(MaidSubConfigPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            if (!(context.player() instanceof class_3222 sender)) {
                return;
            }
            class_1297 entity = sender.field_6002.method_8469(message.id);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                MaidConfigManager.SyncNetwork.handle(message.syncNetwork, maid);
            }
        });
    }
}
