package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Search;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.concurrent.CompletableFuture;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record WChessToClientPackage(class_2338 pos, String fenData) implements class_8710 {
    public static final class_9154<WChessToClientPackage> TYPE = new class_9154<>(getResourceLocation("wchess_to_client"));
    public static final class_9139<ByteBuf, WChessToClientPackage> STREAM_CODEC = class_9139.method_56435(
            class_2338.field_48404,
            WChessToClientPackage::pos,
            class_9135.field_48554,
            WChessToClientPackage::fenData,
            WChessToClientPackage::new
    );

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(WChessToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> CompletableFuture.runAsync(() -> onHandle(message), class_156.method_18349()));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(WChessToClientPackage message) {
        int levelTime = 1000;
        long timeStart = System.currentTimeMillis();
        int move = 0;

        Position position = new Position();
        position.fromFen(message.fenData);

        // 先判断玩家是否赢了
        // 是的，我放客户端，减轻服务端压力，理论上你可直接传布尔值判断女仆输掉来作弊
        boolean maidLost = WChessUtil.isMaid(position) && position.isMate();
        boolean playerLost = false;
        if (!maidLost) {
            // TODO: 暂时不做女仆的棋技系统
            move = new Search(position, 12).searchMain(levelTime);
            // 玩家是否输了
            playerLost = position.makeMove(move) && WChessUtil.isPlayer(position) && position.isMate();
        }

        // 如果时间还有剩余，那么 sleep 一会儿
        long timeRemain = Math.max(0, levelTime - (int) (System.currentTimeMillis() - timeStart));
        try {
            if (timeRemain > 0) {
                Thread.sleep(timeRemain);
            }
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        final int moveFinal = move;
        final boolean playerLostFinal = playerLost;
        class_310.method_1551().method_5382(() -> ClientPlayNetworking.send(new WChessToServerPackage(message.pos, moveFinal, maidLost, playerLostFinal)));
    }
}
