package com.github.tartaricacid.touhoulittlemaid.util;

import cn.sh1rocu.touhoulittlemaid.api.event.EntityJoinLevelEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import java.util.concurrent.TimeUnit;

@Environment(EnvType.CLIENT)
public final class EntityCacheUtil {
    /**
     * 实体缓存，在客户端会大量运用实体渲染，这个缓存可以减少重复创建实体带来的性能问题
     */
    public static final Cache<class_1299<?>, class_1297> ENTITY_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5, TimeUnit.MINUTES).build();
    /**
     * 女仆实体缓存，用于雕像，因为雕像如果共用一个实体，会导致 GeckoLib 动画渲染错误
     */
    public static final Cache<Long, EntityMaid> STATUE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10, TimeUnit.SECONDS).build();
    /**
     * 女仆实体缓存，用于物品形态的手办，因为如果共用一个实体，会导致 GeckoLib 动画渲染错误
     */
    public static final Cache<class_1799, EntityMaid> GARAGE_KIT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10, TimeUnit.SECONDS).build();
    private static class_5321<class_1937> dimAt;

    public static void clearMaidDataResidue(EntityMaid maid, boolean clearEquipmentData) {
        maid.field_6254 = 0;
        maid.field_6235 = 0;
        maid.field_6213 = 0;
        maid.method_24830(true);
        maid.method_6179(false);
        maid.setMaidBackpackType(BackpackManager.getEmptyBackpack());
        maid.method_5665(class_2561.method_43473());
        if (clearEquipmentData) {
            for (class_1304 slot : class_1304.values()) {
                maid.method_5673(slot, class_1799.field_8037);
            }
        }
    }

    public static void onChangeDim(EntityJoinLevelEvent event) {
        if (event.getLevel().field_9236 && event.getEntity() == class_310.method_1551().field_1724) {
            class_5321<class_1937> dim = event.getEntity().field_6002.method_27983();
            if (!dim.equals(dimAt)) {
                dimAt = dim;
                EntityCacheUtil.ENTITY_CACHE.invalidateAll();
            }
        }
    }
}
