package com.github.tartaricacid.touhoulittlemaid.util;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.PlayerMainInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class ItemsUtil {
    private ItemsUtil() {
    }

    /**
     * 掉落指定起始、结束槽位的物品
     */
    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; i++) {
            class_1799 stackInSlot = itemHandler.getStackInSlot(i);
            class_1799 extractItem = itemHandler.extractItem(i, stackInSlot.method_7947(), false);
            if (!extractItem.method_7960()) {
                entity.method_5775(extractItem);
            }
        }
    }

    /**
     * 掉落指定起始的物品
     */
    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler, int startIndex) {
        dropEntityItems(entity, itemHandler, startIndex, itemHandler.getSlots());
    }

    /**
     * 掉落全部物品
     */
    public static void dropEntityItems(class_1297 entity, IItemHandler itemHandler) {
        dropEntityItems(entity, itemHandler, 0, itemHandler.getSlots());
    }

    /**
     * 传入 IItemHandler 和判定条件 filter，获取对应的格子数
     *
     * @return 如果没找到，返回 -1
     */
    public static int findStackSlot(IItemHandler handler, Predicate<class_1799> filter) {
        for (int i = 0; i < handler.getSlots(); i++) {
            class_1799 stack = handler.getStackInSlot(i);
            if (filter.test(stack)) {
                return i;
            }
        }
        return -1;
    }

    /**
     * 获取符合条件的 slot 列表
     */
    public static List<Integer> getFilterStackSlots(IItemHandler handler, Predicate<class_1799> filter) {
        IntList slots = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); i++) {
            class_1799 stack = handler.getStackInSlot(i);
            if (filter.test(stack)) {
                slots.add(i);
            }
        }
        return slots;
    }

    /**
     * 符合 filter 条件的物品是否在 handler 中
     */
    public static boolean isStackIn(IItemHandler handler, Predicate<class_1799> filter) {
        return findStackSlot(handler, filter) >= 0;
    }

    public static boolean isStackIn(EntityMaid maid, Predicate<class_1799> filter) {
        return findStackSlot(maid.getAvailableInv(false), filter) >= 0;
    }

    /**
     * 获取符合 filter 添加的 ItemStack
     *
     * @return 如果该物品不存在，返回 ItemStack.EMPTY
     */
    public static class_1799 getStack(IItemHandler handler, Predicate<class_1799> filter) {
        int slotIndex = findStackSlot(handler, filter);
        if (slotIndex >= 0) {
            return handler.getStackInSlot(slotIndex);
        } else {
            return class_1799.field_8037;
        }
    }

    public static class_1799 getStack(EntityMaid maid, Predicate<class_1799> filter) {
        return getStack(maid.getAvailableInv(false), filter);
    }

    /**
     * 获取女仆饰品栏的饰品数据
     * <p>
     * 此方法为遍历查找，性能为 O(n)，不适合频繁调用
     *
     * @return 如果没找到，返回 -1
     */
    public static int getBaubleSlotInMaid(EntityMaid maid, IMaidBauble bauble) {
        BaubleItemHandler handler = maid.getMaidBauble();
        return handler.getBaubleSlot(bauble);
    }

    /**
     * 女仆是否拥有该饰品物品
     * <p>
     * 此方法采用了缓存机制，性能为 O(1)，适合频繁调用
     */
    @ApiStatus.AvailableSince("1.4.3")
    public static boolean hasBaubleItemInMaid(EntityMaid maid, class_1792 bauble) {
        BaubleItemHandler handler = maid.getMaidBauble();
        return handler.containsItem(bauble);
    }

    /**
     * 女仆是否拥有该饰品物品
     * <p>
     * 此方法采用了缓存机制，性能为 O(1)，适合频繁调用
     */
    @ApiStatus.AvailableSince("1.4.3")
    public static boolean hasBaubleStackInMaid(EntityMaid maid, class_1799 bauble) {
        return hasBaubleItemInMaid(maid, bauble.method_7909());
    }

    /**
     * 获取物品Id
     */
    public static String getItemId(class_1792 item) {
        class_2960 key = class_7923.field_41178.method_10221(item);
        Preconditions.checkNotNull(key);
        if (key == class_7923.field_41178.method_10137()) {
            throw new NullPointerException("item can't be default key");
        }
        return key.toString();
    }


    /**
     * 获取物品
     */
    public static class_1799 getItemStack(String itemId) {
        class_2960 resourceLocation = class_2960.method_60654(itemId);
        class_1792 value = class_7923.field_41178.method_10223(resourceLocation);
        return new class_1799(value);
    }

    public static void giveItemToMaid(EntityMaid maid, class_1799 itemStack) {
        IItemHandler inv = maid.getAvailableInv(false);
        class_1799 stack = ItemHandlerHelper.insertItemStacked(inv, itemStack, false);
        if (!stack.method_7960()) {
            class_1542 itemEntity = new class_1542(maid.method_37908(), maid.method_23317(), maid.method_23318() + 0.5, maid.method_23321(), stack);
            maid.field_6002.method_8649(itemEntity);
        }
    }

    /**
     * 判断玩家主背包（包括快捷栏）能否插入物品
     *
     * @param player 要检查的玩家
     * @return 如果背包已满返回true，否则返回false
     */
    public static boolean canItemInsert(class_1657 player, class_1799 testStack) {
        // 获取玩家主背包的物品处理器（与giveItemToPlayer使用相同的包装器）
        IItemHandler inventory = new PlayerMainInvWrapper(player.method_31548());

        // 遍历所有背包槽位
        for (int i = 0; i < inventory.getSlots(); i++) {
            // 模拟插入物品（第三个参数为true表示仅测试，不实际修改物品栏）
            class_1799 remainder = inventory.insertItem(i, testStack, true);

            // 如果插入后没有剩余，说明该槽位可以容纳物品
            if (remainder.method_7960()) {
                return true;
            }
        }

        // 所有槽位都无法容纳测试物品
        return false;
    }
}