package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

import java.util.Optional;


/**
 * From JEI: <a href="https://github.com/mezz/JustEnoughItems/blob/1.20/Fabric/src/main/java/mezz/jei/fabric/platform/FluidHelper.java">...</a>
 */
@Environment(EnvType.CLIENT)
public final class MaidFluidRender {
    private static final int TEXTURE_SIZE = 16;

    public static class_2561 getFluidName(String fluidId, long amount) {
        class_3611 fluid = class_7923.field_41173.method_10223(class_2960.method_60654(fluidId));
        if (amount <= 0 || fluid == null || fluid.method_15780(class_3612.field_15906)) {
            return class_2561.method_43471("tooltips.touhou_little_maid.tank_backpack.empty_fluid");
        }
        //return fluid.getFluidType().getDescription();
        return FluidVariantAttributes.getName(FluidVariant.of(fluid));
    }

    public static void drawFluid(class_332 graphics, int x, int y, int width, int height, String fluidId, int amount, int capacity) {
        class_3611 fluid = class_7923.field_41173.method_10223(class_2960.method_60654(fluidId));
        if (amount <= 0 || fluid == null || fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidVariant fluidStack = FluidVariant.of(fluid);
        getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = getColorTint(fluidStack);
            int scaledAmount = (amount * height) / capacity;
            if (scaledAmount < 1) {
                // 至少渲染一行像素，让人知道里面有东西
                scaledAmount = 1;
            }
            if (scaledAmount > height) {
                scaledAmount = height;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(x, y, 0);
            drawTiledSprite(graphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
            graphics.method_51448().method_22909();
        });
    }

    public static int getColorTint(FluidVariant ingredient) {
        //Fluid fluid = ingredient.getFluid();
        //IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of(fluid);
        //return renderProperties.getTintColor(ingredient);
        return FluidVariantRendering.getColor(ingredient);
    }

    public static Optional<class_1058> getStillFluidSprite(FluidVariant fluidStack) {
        //Fluid fluid = fluidStack.getFluid();
        //IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of(fluid);
        //ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        class_1058 fluidStill = FluidVariantRendering.getSprite(fluidStack);
        return Optional.ofNullable(fluidStill)
/*                .map(f -> Minecraft.getInstance()
                        .getTextureAtlas(InventoryMenu.BLOCK_ATLAS)
                        .apply(f)
                )
                .filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation())*/;
    }

    private static void drawTiledSprite(class_332 guiGraphics, final int tiledWidth, final int tiledHeight, int color, long scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture(0, class_1723.field_21668);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        setGLColorFromInt(color);

        final int xTileCount = tiledWidth / TEXTURE_SIZE;
        final int xRemainder = tiledWidth - (xTileCount * TEXTURE_SIZE);
        final long yTileCount = scaledAmount / TEXTURE_SIZE;
        final long yRemainder = scaledAmount - (yTileCount * TEXTURE_SIZE);

        for (int xTile = 0; xTile <= xTileCount; xTile++) {
            for (int yTile = 0; yTile <= yTileCount; yTile++) {
                int width = (xTile == xTileCount) ? xRemainder : TEXTURE_SIZE;
                long height = (yTile == yTileCount) ? yRemainder : TEXTURE_SIZE;
                int x = (xTile * TEXTURE_SIZE);
                int y = tiledHeight - ((yTile + 1) * TEXTURE_SIZE);
                if (width > 0 && height > 0) {
                    long maskTop = TEXTURE_SIZE - height;
                    int maskRight = TEXTURE_SIZE - width;
                    drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100);
                }
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (color >> 16 & 0xFF) / 255.0F;
        float green = (color >> 8 & 0xFF) / 255.0F;
        float blue = (color & 0xFF) / 255.0F;
        float alpha = ((color >> 24) & 0xFF) / 255F;

        RenderSystem.setShaderColor(red, green, blue, alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax = uMax - (maskRight / 16F * (uMax - uMin));
        vMax = vMax - (maskTop / 16F * (vMax - vMin));

        RenderSystem.setShader(class_757::method_34542);

        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16, zLevel).method_22913(uMin, vMax);
        bufferBuilder.method_22918(matrix, xCoord + 16 - maskRight, yCoord + 16, zLevel).method_22913(uMax, vMax);
        bufferBuilder.method_22918(matrix, xCoord + 16 - maskRight, yCoord + maskTop, zLevel).method_22913(uMax, vMin);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + maskTop, zLevel).method_22913(uMin, vMin);
        class_286.method_43433(bufferBuilder.method_60800());
    }
}
