package com.github.tartaricacid.touhoulittlemaid.util;


import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;


/**
 * From: https://github.com/mekanism/Mekanism/blob/master/src/main/java/mekanism/common/util/VoxelShapeUtils.java
 * MIT license
 */
public class VoxelShapeUtils {
    private static final class_243 FROM_ORIGIN = new class_243(-0.5, -0.5, -0.5);

    /**
     * Prints out an easy to copy-paste string representing the cuboid of a shape
     */
    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        TouhouLittleMaid.LOGGER.info("box({}, {}, {}, {}, {}, {}),", Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2),
                Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    /**
     * Prints out a set of strings that make copy-pasting easier, for simplifying a voxel shape
     */
    public static void printSimplified(String name, class_265 shape) {
        TouhouLittleMaid.LOGGER.info("Simplified: {}", name);
        shape.method_1097().method_1090().forEach(box -> print(box.field_1323 * 16, box.field_1322 * 16, box.field_1321 * 16, box.field_1320 * 16, box.field_1325 * 16, box.field_1324 * 16));
    }

    /**
     * Rotates an {@link class_238} to a specific side, similar to how the block states rotate models.
     *
     * @param box  The {@link class_238} to rotate
     * @param side The side to rotate it to.
     * @return The rotated {@link class_238}
     */
    public static class_238 rotate(class_238 box, class_2350 side) {
        return switch (side) {
            case field_11033 -> box;
            case field_11036 -> new class_238(box.field_1323, -box.field_1322, -box.field_1321, box.field_1320, -box.field_1325, -box.field_1324);
            case field_11043 -> new class_238(box.field_1323, -box.field_1321, box.field_1322, box.field_1320, -box.field_1324, box.field_1325);
            case field_11035 -> new class_238(-box.field_1323, -box.field_1321, -box.field_1322, -box.field_1320, -box.field_1324, -box.field_1325);
            case field_11039 -> new class_238(box.field_1322, -box.field_1321, -box.field_1323, box.field_1325, -box.field_1324, -box.field_1320);
            case field_11034 -> new class_238(-box.field_1322, -box.field_1321, box.field_1323, -box.field_1325, -box.field_1324, box.field_1320);
        };
    }

    /**
     * Rotates an {@link class_238} according to a specific rotation.
     *
     * @param box      The {@link class_238} to rotate
     * @param rotation The rotation we are performing.
     * @return The rotated {@link class_238}
     */
    public static class_238 rotate(class_238 box, class_2470 rotation) {
        return switch (rotation) {
            case field_11467 -> box;
            case field_11463 -> new class_238(-box.field_1321, box.field_1322, box.field_1323, -box.field_1324, box.field_1325, box.field_1320);
            case field_11464 -> new class_238(-box.field_1323, box.field_1322, -box.field_1321, -box.field_1320, box.field_1325, -box.field_1324);
            case field_11465 -> new class_238(box.field_1321, box.field_1322, -box.field_1323, box.field_1324, box.field_1325, -box.field_1320);
        };
    }

    /**
     * Rotates an {@link class_238} to a specific side horizontally. This is a default most common rotation setup as to {@link #rotate(class_238, class_2470)}
     *
     * @param box  The {@link class_238} to rotate
     * @param side The side to rotate it to.
     * @return The rotated {@link class_238}
     */
    public static class_238 rotateHorizontal(class_238 box, class_2350 side) {
        return switch (side) {
            case field_11043 -> rotate(box, class_2470.field_11467);
            case field_11035 -> rotate(box, class_2470.field_11464);
            case field_11039 -> rotate(box, class_2470.field_11465);
            case field_11034 -> rotate(box, class_2470.field_11463);
            default -> box;
        };
    }

    /**
     * Rotates a {@link class_265} to a specific side, similar to how the block states rotate models.
     *
     * @param shape The {@link class_265} to rotate
     * @param side  The side to rotate it to.
     * @return The rotated {@link class_265}
     */
    public static class_265 rotate(class_265 shape, class_2350 side) {
        return rotate(shape, box -> rotate(box, side));
    }

    /**
     * Rotates a {@link class_265} according to a specific rotation.
     *
     * @param shape    The {@link class_265} to rotate
     * @param rotation The rotation we are performing.
     * @return The rotated {@link class_265}
     */
    public static class_265 rotate(class_265 shape, class_2470 rotation) {
        return rotate(shape, box -> rotate(box, rotation));
    }

    /**
     * Rotates a {@link class_265} to a specific side horizontally. This is a default most common rotation setup as to {@link #rotate(class_265, class_2470)}
     *
     * @param shape The {@link class_265} to rotate
     * @param side  The side to rotate it to.
     * @return The rotated {@link class_265}
     */
    public static class_265 rotateHorizontal(class_265 shape, class_2350 side) {
        return rotate(shape, box -> rotateHorizontal(box, side));
    }

    /**
     * Rotates a {@link class_265} using a specific transformation function for each {@link class_238} in the {@link class_265}.
     *
     * @param shape          The {@link class_265} to rotate
     * @param rotateFunction The transformation function to apply to each {@link class_238} in the {@link class_265}.
     * @return The rotated {@link class_265}
     */
    public static class_265 rotate(class_265 shape, UnaryOperator<class_238> rotateFunction) {
        List<class_265> rotatedPieces = new ArrayList<>();
        //Explode the voxel shape into bounding boxes
        List<class_238> sourceBoundingBoxes = shape.method_1090();
        //Rotate them and convert them each back into a voxel shape
        for (class_238 sourceBoundingBox : sourceBoundingBoxes) {
            //Make the bounding box be centered around the middle, and then move it back after rotating
            rotatedPieces.add(class_259.method_1078(rotateFunction.apply(sourceBoundingBox.method_989(FROM_ORIGIN.field_1352, FROM_ORIGIN.field_1351, FROM_ORIGIN.field_1350))
                    .method_989(-FROM_ORIGIN.field_1352, -FROM_ORIGIN.field_1350, -FROM_ORIGIN.field_1350)));
        }
        //return the recombined rotated voxel shape
        return combine(rotatedPieces);
    }

    /**
     * Used for mass combining shapes
     *
     * @param shapes The list of {@link class_265}s to include
     * @return A simplified {@link class_265} including everything that is part of the input shapes.
     */
    public static class_265 combine(class_265... shapes) {
        return batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    /**
     * Used for mass combining shapes
     *
     * @param shapes The collection of {@link class_265}s to include
     * @return A simplified {@link class_265} including everything that is part of the input shapes.
     */
    public static class_265 combine(Collection<class_265> shapes) {
        return batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    /**
     * Used for cutting shapes out of a full cube
     *
     * @param shapes The list of {@link class_265}s to cut out
     * @return A {@link class_265} including everything that is not part of the input shapes.
     */
    public static class_265 exclude(class_265... shapes) {
        return batchCombine(class_259.method_1077(), class_247.field_16886, true, shapes);
    }

    /**
     * Used for mass combining shapes using a specific {@link class_247} and a given start shape.
     *
     * @param initial  The {@link class_265} to start with
     * @param function The {@link class_247} to perform
     * @param simplify True if the returned shape should run {@link class_265#method_1097()}, False otherwise
     * @param shapes   The collection of {@link class_265}s to include
     * @return A {@link class_265} based on the input parameters.
     * @implNote We do not do any simplification until after combining all the shapes, and then only if the {@code simplify} is True. This is because there is a
     * performance hit in calculating the simplified shape each time if we still have more changers we are making to it.
     */
    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, Collection<class_265> shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082(combinedShape, shape, function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }

    /**
     * Used for mass combining shapes using a specific {@link class_247} and a given start shape.
     *
     * @param initial  The {@link class_265} to start with
     * @param function The {@link class_247} to perform
     * @param simplify True if the returned shape should run {@link class_265#method_1097()}, False otherwise
     * @param shapes   The list of {@link class_265}s to include
     * @return A {@link class_265} based on the input parameters.
     * @implNote We do not do any simplification until after combining all the shapes, and then only if the {@code simplify} is True. This is because there is a
     * performance hit in calculating the simplified shape each time if we still have more changers we are making to it.
     */
    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, class_265... shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082(combinedShape, shape, function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }
}
