package cn.sh1rocu.touhoulittlemaid.util.compat.tacz;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import net.minecraft.class_1799;

public class ItemHandlerUtil {
    public static int findAndExtractInventoryAmmo(IItemHandler itemHandler, class_1799 gunItem, int needAmmoCount) {
        int cnt = needAmmoCount;
        // 背包检查
        for (int i = 0; i < itemHandler.getSlots(); i++) {
            class_1799 checkAmmoStack = itemHandler.getStackInSlot(i);
            if (checkAmmoStack.method_7909() instanceof IAmmo iAmmo && iAmmo.isAmmoOfGun(gunItem, checkAmmoStack)) {
                class_1799 extractItem = itemHandler.extractItem(i, cnt, false);
                cnt = cnt - extractItem.method_7947();
                if (cnt <= 0) {
                    break;
                }
            }
            if (checkAmmoStack.method_7909() instanceof IAmmoBox iAmmoBox && iAmmoBox.isAmmoBoxOfGun(gunItem, checkAmmoStack)) {
                int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
                int extractCount = Math.min(boxAmmoCount, cnt);
                int remainCount = boxAmmoCount - extractCount;
                iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
                if (remainCount <= 0) {
                    iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
                }
                cnt = cnt - extractCount;
                if (cnt <= 0) {
                    break;
                }
            }
        }
        return needAmmoCount - cnt;
    }
}
