package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_2960;

public class ConditionManager {
    public static Map<class_2960, ConditionalSwing> SWING = Maps.newHashMap();
    public static Map<class_2960, ConditionalSwing> SWING_OFFHAND = Maps.newHashMap();
    public static Map<class_2960, ConditionalUse> USE_MAINHAND = Maps.newHashMap();
    public static Map<class_2960, ConditionalUse> USE_OFFHAND = Maps.newHashMap();
    public static Map<class_2960, ConditionalHold> HOLD_MAINHAND = Maps.newHashMap();
    public static Map<class_2960, ConditionalHold> HOLD_OFFHAND = Maps.newHashMap();
    public static Map<class_2960, ConditionTAC> TAC = Maps.newHashMap();
    public static Map<class_2960, ConditionArmor> ARMOR = Maps.newHashMap();
    public static Map<class_2960, ConditionalVehicle> VEHICLE = Maps.newHashMap();
    public static Map<class_2960, ConditionalPassenger> PASSENGER = Maps.newHashMap();
    public static Map<class_2960, ConditionalChair> CHAIR = Maps.newHashMap();

    public static void addTest(class_2960 id, String name) {
        SWING.computeIfAbsent(id, k -> new ConditionalSwing(class_1268.field_5808)).addTest(name);
        SWING_OFFHAND.computeIfAbsent(id, k -> new ConditionalSwing(class_1268.field_5810)).addTest(name);
        USE_MAINHAND.computeIfAbsent(id, k -> new ConditionalUse(class_1268.field_5808)).addTest(name);
        USE_OFFHAND.computeIfAbsent(id, k -> new ConditionalUse(class_1268.field_5810)).addTest(name);
        HOLD_MAINHAND.computeIfAbsent(id, k -> new ConditionalHold(class_1268.field_5808)).addTest(name);
        HOLD_OFFHAND.computeIfAbsent(id, k -> new ConditionalHold(class_1268.field_5810)).addTest(name);
        TAC.computeIfAbsent(id, k -> new ConditionTAC()).addTest(name);
        ARMOR.computeIfAbsent(id, k -> new ConditionArmor()).addTest(name);
        VEHICLE.computeIfAbsent(id, k -> new ConditionalVehicle()).addTest(name);
        PASSENGER.computeIfAbsent(id, k -> new ConditionalPassenger()).addTest(name);
        CHAIR.computeIfAbsent(id, k -> new ConditionalChair()).addTest(name);
    }

    public static void clear() {
        SWING.clear();
        SWING_OFFHAND.clear();
        USE_MAINHAND.clear();
        USE_OFFHAND.clear();
        HOLD_MAINHAND.clear();
        HOLD_OFFHAND.clear();
        TAC.clear();
        ARMOR.clear();
        VEHICLE.clear();
        PASSENGER.clear();
        CHAIR.clear();
    }

    public static ConditionalSwing getSwingMainhand(class_2960 id) {
        return SWING.get(id);
    }

    public static ConditionalSwing getSwingOffhand(class_2960 id) {
        return SWING_OFFHAND.get(id);
    }

    public static ConditionalUse getUseMainhand(class_2960 id) {
        return USE_MAINHAND.get(id);
    }

    public static ConditionalUse getUseOffhand(class_2960 id) {
        return USE_OFFHAND.get(id);
    }

    public static ConditionalHold getHoldMainhand(class_2960 id) {
        return HOLD_MAINHAND.get(id);
    }

    public static ConditionalHold getHoldOffhand(class_2960 id) {
        return HOLD_OFFHAND.get(id);
    }

    public static ConditionArmor getArmor(class_2960 id) {
        return ARMOR.get(id);
    }

    public static ConditionTAC getTAC(class_2960 id) {
        return TAC.get(id);
    }

    public static ConditionalVehicle getVehicle(class_2960 id) {
        return VEHICLE.get(id);
    }

    public static ConditionalPassenger getPassenger(class_2960 id) {
        return PASSENGER.get(id);
    }

    public static ConditionalChair getChair(class_2960 id) {
        return CHAIR.get(id);
    }
}
