package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunClientUtil;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class LayerMaidHeldItem extends class_3887<class_1308, BedrockModel<class_1308>> {
    private final class_759 itemInHandRenderer;

    public LayerMaidHeldItem(EntityMaidRenderer maidRenderer, class_759 pItemInHandRenderer) {
        super(maidRenderer);
        this.itemInHandRenderer = pItemInHandRenderer;
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1308 maid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1799 mainRightItem = maid.method_6047();
        class_1799 offLeftItem = maid.method_6079();
        BedrockModel<class_1308> model = method_17165();
        if (!mainRightItem.method_7960() && model.hasRightArm() && !RenderFixer.isCarryOnRender(mainRightItem, bufferIn)) {
            this.renderArmWithItem(maid, mainRightItem, class_811.field_4320, class_1306.field_6183, poseStack, bufferIn, packedLightIn);
        }
        if (!offLeftItem.method_7960() && model.hasLeftArm() && !RenderFixer.isCarryOnRender(offLeftItem, bufferIn)) {
            this.renderArmWithItem(maid, offLeftItem, class_811.field_4323, class_1306.field_6182, poseStack, bufferIn, packedLightIn);
        }
    }

    private void renderArmWithItem(class_1308 maid, class_1799 itemStack, class_811 transformTypeIn, class_1306 handSide, class_4587 poseStack, class_4597 typeBuffer, int combinedLightIn) {
        if (!itemStack.method_7960()) {
            poseStack.method_22903();
            boolean isLeft = handSide == class_1306.field_6182;
            method_17165().translateToHand(handSide, poseStack);
            if (method_17165().hasArmPositioningModel(handSide)) {
                method_17165().translateToPositioningHand(handSide, poseStack);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0F));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
                poseStack.method_22904(0, 0.125, -0.0625);
            } else {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0F));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
                poseStack.method_22904((isLeft ? -1 : 1) / 16.0, 0.125, -0.525);
            }
            GunClientUtil.addItemTranslate(poseStack, itemStack, isLeft);
            this.itemInHandRenderer.method_3233(maid, itemStack, transformTypeIn, isLeft, poseStack, typeBuffer, combinedLightIn);
            poseStack.method_22909();
        }
    }
}
