package com.github.tartaricacid.touhoulittlemaid.client.sound.data;

import com.github.tartaricacid.touhoulittlemaid.api.client.sound.ICustomSoundBuffer;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4231;

public class MaidSoundInstance extends class_1101 implements ICustomSoundBuffer {
    private final String id;
    private final EntityMaid maid;
    private final boolean testSound;

    public MaidSoundInstance(class_3414 soundEvent, String id, EntityMaid maid) {
        this(soundEvent, id, maid, false);
    }

    public MaidSoundInstance(class_3414 soundEvent, String id, EntityMaid maid, boolean testSound) {
        super(soundEvent, class_3419.field_15254, class_1113.method_43221());
        this.id = id;
        this.maid = maid;
        this.testSound = testSound;
        this.field_5439 = this.maid.method_23317();
        this.field_5450 = this.maid.method_23318();
        this.field_5449 = this.maid.method_23321();
    }

    @Override
    public boolean method_26273() {
        return !this.maid.method_5701();
    }

    @Override
    public void method_16896() {
        if (this.maid.method_31481()) {
            this.method_24876();
        } else {
            this.field_5439 = this.maid.method_23317();
            this.field_5450 = this.maid.method_23318();
            this.field_5449 = this.maid.method_23321();
        }
    }

    public String getId() {
        return id;
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public boolean isTestSound() {
        return testSound;
    }

    @Nullable
    @Override
    public class_4231 getSoundBuffer() {
        SoundCache soundCache = CustomSoundLoader.getSoundCache(id);
        if (soundCache != null) {
            return soundCache.getBuffer(field_5448);
        }
        return null;
    }
}
