package com.github.tartaricacid.touhoulittlemaid.client.sound.data;

import com.github.tartaricacid.touhoulittlemaid.api.client.sound.ICustomSoundBuffer;
import com.github.tartaricacid.touhoulittlemaid.client.sound.CustomSoundLoader;
import javax.annotation.Nullable;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4231;

public class MaidSoundInstanceAtPos extends class_1102 implements ICustomSoundBuffer {
    private final String id;
    private final boolean test;

    public MaidSoundInstanceAtPos(class_3414 soundEvent, String id,
                                  double x, double y, double z,
                                  float volume, float pitch) {
        this(soundEvent, id, x, y, z, volume, pitch, false);
    }

    public MaidSoundInstanceAtPos(class_3414 soundEvent, String id,
                                  double x, double y, double z,
                                  float volume, float pitch, boolean test) {
        super(soundEvent, class_3419.field_15254, class_1113.method_43221());
        this.id = id;
        this.test = test;
        this.field_5439 = x;
        this.field_5450 = y;
        this.field_5449 = z;
        this.field_5442 = volume;
        this.field_5441 = pitch;
    }

    @Override
    public boolean method_26273() {
        return true;
    }

    public String getId() {
        return id;
    }

    public boolean isTest() {
        return test;
    }

    @Nullable
    @Override
    public class_4231 getSoundBuffer() {
        SoundCache soundCache = CustomSoundLoader.getSoundCache(id);
        if (soundCache != null) {
            return soundCache.getBuffer(field_5448);
        }
        return null;
    }
}

