package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.item.ItemCamera;
import com.github.tartaricacid.touhoulittlemaid.world.backups.MaidBackupsManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.network.chat.*;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class BackupCommand {
    private static final String BACKUP_NAME = "backup";
    private static final String GET_NAME = "get";
    private static final String PLAYER_NAME = "player";
    private static final String MAID_UUID = "maid_uuid";
    private static final String FILE_NAME = "file_name";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> root = class_2170.method_9247(BACKUP_NAME);
        LiteralArgumentBuilder<class_2168> get = class_2170.method_9247(GET_NAME);

        RequiredArgumentBuilder<class_2168, class_2300> player = class_2170.method_9244(PLAYER_NAME, class_2186.method_9305());
        RequiredArgumentBuilder<class_2168, UUID> maidUuid = class_2170.method_9244(MAID_UUID, class_5242.method_27643());
        RequiredArgumentBuilder<class_2168, String> fileName = class_2170.method_9244(FILE_NAME, StringArgumentType.string());

        root.then(get.then(player.executes(BackupCommand::handlePlayerMaidIndex)));
        root.then(get.then(player.then(maidUuid.executes(BackupCommand::handlePlayerMaid))));
        root.then(get.then(player.then(maidUuid.then(fileName.executes(BackupCommand::handlePlayerMaidFile)))));

        return root;
    }

    private static String getFormattedTime(long timestamp) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(timestamp / 1000, 0, ZoneOffset.UTC);
        return dateTime.format(DateTimeFormatter.ofPattern("(MM/dd HH:mm)"));
    }

    private static int handlePlayerMaidIndex(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, PLAYER_NAME);
        var maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);

        // 如果没找到
        if (maidIndexMap.isEmpty()) {
            class_5250 error = class_2561.method_43469("message.touhou_little_maid.maid_backup.player.no_data", player.method_5820());
            player.method_43496(error.method_27692(class_124.field_1061));
            return Command.SINGLE_SUCCESS;
        }

        // 将 maidIndexMap 按照时间戳，从新到旧排序
        maidIndexMap = maidIndexMap.entrySet().stream()
                .sorted(Map.Entry.comparingByValue(
                        Comparator.comparingLong(MaidBackupsManager.IndexData::timestamp).reversed()
                ))
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (e1, e2) -> e1,
                        LinkedHashMap::new
                ));

        class_5250 separator = class_2561.method_43469("message.touhou_little_maid.maid_backup.player.separator", player.method_5820());
        player.method_43496(separator.method_27692(class_124.field_1077));

        // 把女仆的信息按行打印出来，显示名称、坐标和维度
        int index = 1;
        for (var entry : maidIndexMap.entrySet()) {
            UUID id = entry.getKey();
            MaidBackupsManager.IndexData data = entry.getValue();

            String time = "§7" + getFormattedTime(data.timestamp());
            class_5250 msg = class_2561.method_43470("§7%d.".formatted(index))
                    .method_10852(class_5244.field_41874)
                    .method_10852(data.name())
                    .method_27692(class_124.field_1065)
                    .method_10852(class_5244.field_41874)
                    .method_27693(time);

            class_5250 dimension = class_2561.method_43469("tooltips.touhou_little_maid.fox_scroll.dimension", data.dimension());
            class_5250 pos = class_2561.method_43469("tooltips.touhou_little_maid.fox_scroll.position", data.pos().method_23854());
            String command = "/tlm backup get @s %s".formatted(id);

            class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, class_5244.method_37110(dimension, pos));
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11750, command);

            msg.method_27694(style -> style.method_10949(hoverEvent))
                    .method_27694(style -> style.method_10958(clickEvent));

            player.method_43496(msg);
            index++;
        }

        return Command.SINGLE_SUCCESS;
    }

    private static int handlePlayerMaid(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, PLAYER_NAME);
        UUID uuid = class_5242.method_27645(context, MAID_UUID);

        var maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        var indexData = maidIndexMap.get(uuid);
        if (indexData == null) {
            class_5250 error = class_2561.method_43469("message.touhou_little_maid.maid_backup.maid.not_found", uuid);
            player.method_43496(error.method_27692(class_124.field_1061));
            return Command.SINGLE_SUCCESS;
        }

        class_5250 separator = class_2561.method_43469("message.touhou_little_maid.maid_backup.maid.separator", indexData.name());
        player.method_43496(separator.method_27692(class_124.field_1077));

        var backupFiles = MaidBackupsManager.getMaidBackupFiles(player, uuid);
        for (String backupFile : backupFiles) {
            class_5250 msg = class_2561.method_43470(backupFile).method_27692(class_124.field_1064);

            String command = "/tlm backup get @s %s \"%s\"".formatted(uuid, backupFile);
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11750, command);
            msg.method_27694(style -> style.method_10958(clickEvent));

            player.method_43496(msg);
        }

        return Command.SINGLE_SUCCESS;
    }

    private static int handlePlayerMaidFile(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, PLAYER_NAME);
        UUID uuid = class_5242.method_27645(context, MAID_UUID);
        String fileName = StringArgumentType.getString(context, FILE_NAME);

        class_2487 backupData = MaidBackupsManager.getMaidBackFile(player, uuid, fileName);
        if (backupData.method_33133()) {
            class_5250 error = class_2561.method_43469("message.touhou_little_maid.maid_backup.file.not_found", fileName);
            player.method_43496(error.method_27692(class_124.field_1061));
            return Command.SINGLE_SUCCESS;
        }

        // 生成包含此女仆信息的照片
        ItemCamera.spawnMaidPhoto(player.field_6002, backupData, player);
        // 发送成功信息
        class_5250 success = class_2561.method_43469("message.touhou_little_maid.maid_backup.file.success", fileName);
        player.method_43496(success.method_27692(class_124.field_1060));
        return Command.SINGLE_SUCCESS;
    }
}
