package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record OpenChairGuiPackage(int id) implements class_8710 {
    public static final class_8710.class_9154<OpenChairGuiPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("open_chair_gui"));
    public static final class_9139<ByteBuf, OpenChairGuiPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550,
            OpenChairGuiPackage::id,
            OpenChairGuiPackage::new
    );

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(OpenChairGuiPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> handleOpenGui(message));
    }

    @Environment(EnvType.CLIENT)
    private static void handleOpenGui(OpenChairGuiPackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(message.id);
        if (mc.field_1724 != null && mc.field_1724.method_5805() && e instanceof EntityChair chair && e.method_5805()) {
            CacheIconManager.openChairModelGui(chair);
        }
    }
}
