package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record WirelessIOSlotConfigPackage(List<Boolean> configData) implements class_8710 {
    public static final class_8710.class_9154<WirelessIOSlotConfigPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("wireless_slot_config"));
    public static final class_9139<ByteBuf, WirelessIOSlotConfigPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48547.method_56433(class_9135.method_56363()),
            WirelessIOSlotConfigPackage::configData,
            WirelessIOSlotConfigPackage::new
    );
    private static final List<Boolean> EMPTY = new ArrayList<>();

    public WirelessIOSlotConfigPackage() {
        this(EMPTY);
    }

    public static void handle(WirelessIOSlotConfigPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1799 handItem = sender.method_6047();
            if (handItem.method_7909() == InitItems.WIRELESS_IO) {
                if (!message.configData.isEmpty()) {
                    ItemWirelessIO.setSlotConfig(handItem, message.configData);
                }
                sender.method_17355((ItemWirelessIO) handItem.method_7909());
            }
        });
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
