package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;

public abstract class PlayerTickEvent {
    private final class_1657 player;

    public PlayerTickEvent(class_1657 player) {
        this.player = player;
    }

    public static final Event<Pre.Callback> START = EventFactory.createArrayBacked(Pre.Callback.class, callbacks -> event -> {
        for (final Pre.Callback callback : callbacks)
            callback.onStart(event);
    });
    public static final Event<Post.Callback> END = EventFactory.createArrayBacked(Post.Callback.class, callbacks -> event -> {
        for (final Post.Callback callback : callbacks)
            callback.onEnd(event);
    });

    public class_1657 getEntity() {
        return player;
    }

    public static class Pre extends PlayerTickEvent {
        public Pre(class_1657 player) {
            super(player);
        }

        public interface Callback {
            void onStart(Pre event);
        }
    }

    public static class Post extends PlayerTickEvent {
        public Post(class_1657 player) {
            super(player);
        }

        public interface Callback {
            void onEnd(Post event);
        }
    }
}