package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.api.event.ProjectileImpactEvent;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// PortingLib
@Mixin(class_1665.class)
public abstract class AbstractArrowMixin extends class_1297 {
    @Shadow
    public abstract void setPierceLevel(byte b);

    @Unique
    private final IntOpenHashSet tlm$ignoredEntities = new IntOpenHashSet();

    public AbstractArrowMixin(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    @Inject(method = "canHitEntity", at = @At("HEAD"), cancellable = true)
    private void tlm$dontHitIgnored(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (tlm$ignoredEntities.contains(entity.method_5628()))
            cir.setReturnValue(false);
    }

    @WrapWithCondition(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;onHit(Lnet/minecraft/world/phys/HitResult;)V"
            )
    )
    private boolean tlm$onImpact(class_1665 arrow, class_239 result,
                                 @Local LocalRef<class_3966> entityHit,
                                 @Share("isCanceled") LocalBooleanRef isCanceled) {
        // note: Forge additionally checks that the result != MISS before running any logic.
        // this is likely left over from an earlier version.
        // this behavior is intentionally not replicated because 1. compat and 2. it probably doesn't matter.
        ProjectileImpactEvent event = new ProjectileImpactEvent(arrow, result);
        ProjectileImpactEvent.CALLBACK.invoker().post(event);

        boolean canceled = switch (event.getResult()) {
            case SKIP_ENTITY -> {
                if (result.method_17783() != class_239.class_240.field_1331) {
                    // didn't hit an entity, do vanilla logic
                    yield false;
                } else {
                    this.tlm$ignoredEntities.add(entityHit.get().method_17782().method_5628());
                    // cancel and skip further processing
                    entityHit.set(null);
                    yield true;
                }
            }
            case STOP_AT_CURRENT_NO_DAMAGE -> {
                this.method_31472();
                // cancel and skip further processing
                entityHit.set(null);
                yield true;
            }
            case STOP_AT_CURRENT -> {
                this.setPierceLevel((byte) 0);
                // does not cancel
                yield false;
            }
            case DEFAULT -> false; // don't cancel, do vanilla logic
        };

        if (canceled) {
            // need to save this. have to separately cancel the hasImpulse set
            isCanceled.set(true);
            return false;
        }

        return true;
    }

    @WrapWithCondition(
            method = "tick",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;hasImpulse:Z"
            )
    )
    private boolean tlm$handleImpulse(class_1665 instance, boolean value,
                                      @Share("isCanceled") LocalBooleanRef isCanceled) {
        boolean canceled = isCanceled.get();
        isCanceled.set(false); // reset, don't leak state
        return !canceled;
    }
}