package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.api.extension.IEnchantment;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1890.class)
public class EnchantmentHelperMixin {
    @Unique
    private static class_1887 tlm$currentEnchantment = null;

    @ModifyExpressionValue(
            method = "getAvailableEnchantmentResults",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/util/Iterator;next()Ljava/lang/Object;"
            )
    )
    private static Object tlm$grabEnchantment(Object o) {
        if (o instanceof class_1887 e) {
            tlm$currentEnchantment = e;
        }
        return o;
    }

    @WrapOperation(
            method = "getAvailableEnchantmentResults",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/enchantment/EnchantmentCategory;canEnchant(Lnet/minecraft/world/item/Item;)Z"
            )
    )
    private static boolean tlm$canApplyAtEnchantingTable(
            class_1886 category, class_1792 item, Operation<Boolean> original,
            int level, class_1799 stack, boolean allowTreasure
    ) {
        class_1887 enchantment = tlm$currentEnchantment;
        if (enchantment != null && stack.method_7909() instanceof IEnchantment ex) {
            return ex.tlm$canApplyAtEnchantingTable(stack, enchantment);
        }
        return original.call(category, item);
    }
}