package cn.sh1rocu.touhoulittlemaid.util.forge;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CRAFTHELPER = MarkerManager.getMarker("CRAFTHELPER");
    private static Gson GSON = (new GsonBuilder()).setPrettyPrinting().disableHtmlEscaping().create();

    public static class_1799 getItemStack(JsonObject json, boolean readNBT) {
        return getItemStack(json, readNBT, false);
    }

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_7923.field_41178.method_10250(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        } else {
            class_1792 item = (class_1792) class_7923.field_41178.method_10223(itemKey);
            if (disallowsAirInRecipe && item == class_1802.field_8162) {
                throw new JsonSyntaxException("Invalid item: " + itemName);
            } else {
                return (class_1792) Objects.requireNonNull(item);
            }
        }
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            return element.isJsonObject() ? class_2522.method_10718(GSON.toJson(element)) : class_2522.method_10718(class_3518.method_15287(element, "nbt"));
        } catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf(e));
        }
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265(json, "item");
        class_1792 item = getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                tmp.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }

            tmp.method_10566("tag", nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282(json, "count", 1));
            return class_1799.method_7915(tmp);
        } else {
            return new class_1799(item, class_3518.method_15282(json, "count", 1));
        }
    }
}
