package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import java.util.List;
import java.util.Optional;

public record ChatClientInfo(String language, String name, List<String> description) {
    public void encode(class_2540 buf) {
        buf.method_10814(language);
        buf.method_10814(name);
        buf.method_10804(description.size());
        for (String line : description) {
            buf.method_10814(line);
        }
    }

    public static ChatClientInfo decode(class_2540 buf) {
        String language = buf.method_19772();
        String name = buf.method_19772();
        int size = buf.method_10816();
        List<String> description = Lists.newArrayListWithExpectedSize(size);
        for (int i = 0; i < size; i++) {
            description.add(buf.method_19772());
        }
        return new ChatClientInfo(language, name, description);
    }

    @Environment(EnvType.CLIENT)
    public static ChatClientInfo fromMaid(EntityMaid maid) {
        String language = getClientLanguage();
        String name = getMaidName(maid);
        List<String> description = getMaidDescription(maid);
        return new ChatClientInfo(language, name, description);
    }

    @Environment(EnvType.CLIENT)
    private static String getClientLanguage() {
        return class_310.method_1551().method_1526().method_4669();
    }

    @Environment(EnvType.CLIENT)
    private static String getMaidName(EntityMaid maid) {
        return maid.method_5477().getString();
    }

    @Environment(EnvType.CLIENT)
    private static List<String> getMaidDescription(EntityMaid maid) {
        List<String> description = Lists.newArrayList();
        // YSM 模型没有描述文本
        if (YsmCompat.isInstalled() && maid.isYsmModel()) {
            return description;
        }
        // 然后才是默认描述文本
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId());
        if (info.isPresent()) {
            MaidModelInfo maidModelInfo = info.get();
            List<class_2561> parse = ParseI18n.parse(maidModelInfo.getDescription());
            parse.forEach(component -> description.add(component.getString()));
        }
        return description;
    }
}