package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.util.particle.ParticleUtil;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_727;
import net.minecraft.class_7923;
import net.minecraft.world.entity.*;
import net.minecraft.world.level.block.*;
import javax.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class BlockGarageKit extends class_2248 implements class_2343, IBlock {
    public static final class_265 BLOCK_AABB = class_2248.method_9541(4, 0, 4, 12, 16, 12);
    private static final String ENTITY_INFO = "EntityInfo";

    @Override
    public boolean tlm$addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        if (target instanceof class_3965 blockTarget && world instanceof class_638 clientWorld) {
            class_2338 pos = blockTarget.method_17777();
            this.crack(clientWorld, pos, class_2246.field_10460.method_9564(), blockTarget.method_17780());
        }
        return true;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean tlm$addDestroyEffects(class_2680 state, class_1937 world, class_2338 pos, class_702 manager) {
        class_310.method_1551().field_1713.method_3046(pos, class_2246.field_10460.method_9564());
        return true;
    }

    @Environment(EnvType.CLIENT)
    private void crack(class_638 world, class_2338 pos, class_2680 state, class_2350 side) {
        if (state.method_26217() != class_2464.field_11455) {
            int posX = pos.method_10263();
            int posY = pos.method_10264();
            int posZ = pos.method_10260();
            class_238 aabb = state.method_26218(world, pos).method_1107();
            double x = posX + world.field_9229.method_43058() * (aabb.field_1320 - aabb.field_1323 - 0.2) + 0.1 + aabb.field_1323;
            double y = posY + world.field_9229.method_43058() * (aabb.field_1325 - aabb.field_1322 - 0.2) + 0.1 + aabb.field_1322;
            double z = posZ + world.field_9229.method_43058() * (aabb.field_1324 - aabb.field_1321 - 0.2) + 0.1 + aabb.field_1321;
            if (side == class_2350.field_11033) {
                y = posY + aabb.field_1322 - 0.1;
            }
            if (side == class_2350.field_11036) {
                y = posY + aabb.field_1325 + 0.1;
            }
            if (side == class_2350.field_11043) {
                z = posZ + aabb.field_1321 - 0.1;
            }
            if (side == class_2350.field_11035) {
                z = posZ + aabb.field_1324 + 0.1;
            }
            if (side == class_2350.field_11039) {
                x = posX + aabb.field_1323 - 0.1;
            }
            if (side == class_2350.field_11034) {
                x = posX + aabb.field_1320 + 0.1;
            }
            class_727 diggingParticle = new class_727(world, x, y, z, 0, 0, 0, state);
            class_310.method_1551().field_1713.method_3058(ParticleUtil.updateSprite(diggingParticle, state, pos).method_3075(0.2f).method_3087(0.6f));
        }
    }

    public BlockGarageKit() {
        super(class_2251.method_9637().method_9626(class_2498.field_37640).method_9629(1, 2).method_22488());
    }

    @Environment(EnvType.CLIENT)
    public static void fillItemCategory(class_1761.class_7704 items) {
        for (String modelId : CustomPackLoader.MAID_MODELS.getModelIdSet()) {
            class_1799 stack = new class_1799(InitBlocks.GARAGE_KIT);
            class_2487 data = stack.method_7911(ENTITY_INFO);
            data.method_10582("id", Objects.requireNonNull(class_7923.field_41177.method_10221(InitEntities.MAID)).toString());
            data.method_10582(EntityMaid.MODEL_ID_TAG, modelId);
            // 创造模式物品栏数据需要强制指定 YSM 渲染为空
            data.method_10556(EntityMaid.IS_YSM_MODEL_TAG, false);
            items.method_45420(stack);
        }
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityGarageKit(pos, state);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        method_9577(worldIn, pos, getGarageKitFromWorld(worldIn, pos));
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        this.getGarageKit(worldIn, pos).ifPresent(te -> {
            class_2350 facing = class_2350.field_11035;
            if (placer != null) {
                facing = placer.method_5735().method_10153();
            }
            te.setData(facing, ItemGarageKit.getMaidData(stack));
        });
    }

    @Override
    //public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Player player) {
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return getGarageKitFromWorld(world, pos);
    }


    @Override
    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
        class_1799 stack = playerIn.method_5998(hand);
        if (!(worldIn instanceof class_3218) || !(stack.method_7909() instanceof class_1826)) {
            return class_1269.field_5811;
        }
        class_2586 tile = worldIn.method_8321(pos);
        if (!(tile instanceof TileEntityGarageKit)) {
            return class_1269.field_5811;
        }
        TileEntityGarageKit garageKit = (TileEntityGarageKit) tile;
        class_1299<?> type = ((class_1826) stack.method_7909()).method_8015(stack.method_7969());
        class_2960 key = class_7923.field_41177.method_10221(type);
        if (key == class_7923.field_41177.method_10137()) {
            return class_1269.field_5811;
        }

        String id = key.toString();
        class_2487 data = new class_2487();
        data.method_10582("id", id);

        class_1297 entity = type.method_5883(worldIn);
        if (entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308) entity;
            mobEntity.method_5943((class_3218) worldIn, worldIn.method_8404(pos), class_3730.field_16465, null, data);
            mobEntity.method_5652(data);
        }

        garageKit.setData(garageKit.getFacing(), data);
        return class_1269.field_5812;
    }

    private class_1799 getGarageKitFromWorld(class_1922 world, class_2338 pos) {
        class_1799 stack = new class_1799(InitBlocks.GARAGE_KIT);
        getGarageKit(world, pos).ifPresent(te -> stack.method_7948().method_10566(ENTITY_INFO, te.getExtraData()));
        return stack;
    }

    private Optional<TileEntityGarageKit> getGarageKit(class_1922 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof TileEntityGarageKit) {
            return Optional.of((TileEntityGarageKit) te);
        }
        return Optional.empty();
    }

    @Nullable
    public class_1299<?> getType(@Nullable class_2487 nbt) {
        if (nbt != null && nbt.method_10573("EntityTag", class_2520.field_33260)) {
            class_2487 compound = nbt.method_10562("EntityTag");
            if (compound.method_10573("id", class_2520.field_33258)) {
                return class_1299.method_5898(compound.method_10558("id")).orElse(null);
            }
        }
        return null;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return BLOCK_AABB;
    }
}
