package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BaubleButton;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidRender;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHint(button = IPNButton.SORT, horizontalOffset = -36, bottom = -12)
@IPNGuiHint(button = IPNButton.SORT_COLUMNS, horizontalOffset = -24, bottom = -24)
@IPNGuiHint(button = IPNButton.SORT_ROWS, horizontalOffset = -12, bottom = -36)
@IPNGuiHint(button = IPNButton.SHOW_EDITOR, horizontalOffset = -5)
@IPNGuiHint(button = IPNButton.SETTINGS, horizontalOffset = -5)
public class TankBackpackContainerScreen extends AbstractMaidContainerGui<TankBackpackContainer> implements IBackpackContainerScreen {
    private static final class_2960 BACKPACK = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/maid_tank.png");
    private final EntityMaid maid;

    public TankBackpackContainerScreen(TankBackpackContainer container, class_1661 inv, class_2561 titleIn) {
        super(container, inv, titleIn);
        this.field_2779 = 256;
        this.field_2792 = 256;
        this.maid = field_2797.getMaid();
    }

    @Override
    protected void initAdditionWidgets() {
        BaubleButton button = this.getBaubleButton(maid, field_2776, field_2800);
        this.method_37063(button);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, BACKPACK);
        graphics.method_25302(BACKPACK, field_2776 + 85, field_2800 + 36, 0, 0, 165, 128);

        RenderSystem.enableBlend();
        MaidFluidRender.drawFluid(graphics, field_2776 + 200, field_2800 + 108, 29, 50, maid.getBackpackFluid(), this.field_2797.getFluidCount(), (int) TankBackpackData.CAPACITY);
        RenderSystem.setShaderColor(1, 1, 1, 1);
        RenderSystem.disableBlend();
        graphics.method_25302(BACKPACK, field_2776 + 197, field_2800 + 104, 165, 0, 34, 50);

        boolean xInRange = field_2776 + 196 <= x && x <= field_2776 + 196 + 29;
        boolean yInRange = field_2800 + 108 <= y && y <= field_2800 + 108 + 50;
        if (xInRange && yInRange) {
            // Fabric单位转为mB
            class_5250 fluidInfo = class_2561.method_43469("tooltips.touhou_little_maid.tank_backpack.fluid",
                    MaidFluidRender.getFluidName(maid.getBackpackFluid(), this.field_2797.getFluidCount() / 81),
                    this.field_2797.getFluidCount() / 81).method_27692(class_124.field_1080);
            class_5250 capacityInfo = class_2561.method_43469("tooltips.touhou_little_maid.tank_backpack.capacity", TankBackpackData.CAPACITY / 81)
                    .method_27692(class_124.field_1080);
            graphics.method_51434(field_22793, Lists.newArrayList(fluidInfo, capacityInfo), x, y);
        }
    }
}
