package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MonsterListButton;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetAttackListMessage;
import com.google.common.collect.Lists;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@IPNPlayerSideOnly
@IPNGuiHint(button = IPNButton.SORT, horizontalOffset = -36, bottom = -12)
@IPNGuiHint(button = IPNButton.SORT_COLUMNS, horizontalOffset = -24, bottom = -24)
@IPNGuiHint(button = IPNButton.SORT_ROWS, horizontalOffset = -12, bottom = -36)
@IPNGuiHint(button = IPNButton.SHOW_EDITOR, horizontalOffset = -5)
@IPNGuiHint(button = IPNButton.SETTINGS, horizontalOffset = -5)
public class AttackTaskConfigGui extends MaidTaskConfigGui<TaskConfigContainer> {
    private static final class_2960 BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/attack_task_config.png");

    private final Map<class_2960, MonsterType> attackGroups;
    private final List<class_2960> attackGroupsKey;
    private class_342 inputField;
    private int page = 0;

    public AttackTaskConfigGui(TaskConfigContainer screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.attackGroups = Objects.requireNonNullElse(this.getMaid().getData(InitTaskData.ATTACK_LIST), AttackListData.empty()).attackGroups();
        this.attackGroupsKey = Lists.newArrayList();
        this.sortKey();
    }

    private void sortKey() {
        this.attackGroupsKey.clear();

        List<class_2960> hostile = Lists.newArrayList();
        List<class_2960> neutral = Lists.newArrayList();
        List<class_2960> friendly = Lists.newArrayList();

        for (class_2960 id : attackGroups.keySet()) {
            if (attackGroups.get(id) == MonsterType.HOSTILE) {
                hostile.add(id);
            }
            if (attackGroups.get(id) == MonsterType.NEUTRAL) {
                neutral.add(id);
            }
            if (attackGroups.get(id) == MonsterType.FRIENDLY) {
                friendly.add(id);
            }
        }

        attackGroupsKey.addAll(hostile);
        attackGroupsKey.addAll(neutral);
        attackGroupsKey.addAll(friendly);

        this.page = class_3532.method_15340(this.page, 0, (this.attackGroupsKey.size() - 1) / 7);
    }

    @Override
    protected void initAdditionWidgets() {
        int startLeft = field_2776 + 87;
        int startTop = field_2800 + 36;

        this.inputField = new class_342(this.field_22793, startLeft, startTop, 117, 16, class_2561.method_43470("Monster List"));
        this.inputField.method_1880(256);
        this.method_25429(this.inputField);

        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.monster_type.add"), b -> addMonsterType())
                .method_46433(startLeft + 119, startTop - 1).method_46437(44, 18).method_46431());

        this.method_37063(new class_344(startLeft + 121, startTop + 20, 5, 9, 0, 176, 9, BG, b -> {
            this.page = this.page - 1;
            this.page = class_3532.method_15340(this.page, 0, (this.attackGroupsKey.size() - 1) / 7);
            this.method_25426();
        }));
        this.method_37063(new class_344(startLeft + 156, startTop + 20, 5, 9, 5, 176, 9, BG, b -> {
            this.page = this.page + 1;
            this.page = class_3532.method_15340(this.page, 0, (this.attackGroupsKey.size() - 1) / 7);
            this.method_25426();
        }));

        for (int i = 0; i < 7; i++) {
            int index = page * 7 + i;
            if (index >= attackGroupsKey.size()) {
                return;
            }
            class_2960 id = attackGroupsKey.get(index);
            class_1299<?> type = class_7923.field_41177.method_10223(id);
            class_2561 name = type.method_5897();
            int yOffset = startTop + 31 + 13 * i;
            this.method_37063(new MonsterListButton(name, startLeft - 1, yOffset, id, this));
        }
    }

    private void addMonsterType() {
        String value = this.inputField.method_1882();
        if (StringUtils.isBlank(value)) {
            return;
        }
        if (!class_2960.method_20207(value)) {
            return;
        }
        class_2960 id = class_2960.method_12829(value);
        if (id != null && class_7923.field_41177.method_10250(id)) {
            this.attackGroups.put(id, MonsterType.NEUTRAL);
            this.sortKey();
            super.method_25426();
        }
    }

    public void removeMonsterType(class_2960 id) {
        this.attackGroups.remove(id);
        this.sortKey();
        super.method_25426();
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        String value = this.inputField.method_1882();
        super.method_25410(minecraft, width, height);
        this.inputField.method_1852(value);
    }

    @Override
    protected void renderAddition(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.inputField.method_25394(graphics, mouseX, mouseY, partialTicks);

        class_5250 pageText = class_2561.method_43470(String.format("%d/%d", this.page + 1, (this.attackGroupsKey.size() - 1) / 7 + 1));
        graphics.method_27534(field_22793, pageText, field_2776 + 228, field_2800 + 57, 0xFFFFFF);
        graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.monster_type.title"), field_2776 + 147, field_2800 + 57, 0xFFFFFF);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        graphics.method_25302(BG, field_2776 + 80, field_2800 + 28, 0, 0, field_2792, 137);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == GLFW.GLFW_KEY_ESCAPE && Screens.getClient(this).field_1724 != null) {
            Screens.getClient(this).field_1724.method_7346();
        }
        return this.inputField.method_25404(keyCode, scanCode, modifiers) || this.inputField.method_20315() || super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25419() {
        ClientPlayNetworking.send(SetAttackListMessage.ID, SetAttackListMessage.encode(this.getMaid().method_5628(), this.attackGroups));
        super.method_25419();
    }

    public Map<class_2960, MonsterType> getAttackGroups() {
        return attackGroups;
    }
}