package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import java.util.List;

public class EntityChairRenderer extends class_922<EntityChair, BedrockModel<EntityChair>> {
    public static final class_2960 DEFAULT_TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/entity/empty.png");
    private static final String DEFAULT_CHAIR_ID = "touhou_little_maid:cushion";
    public static boolean renderHitBox = true;
    private ChairModelInfo chairInfo;
    private List<Object> chairAnimations;
    private final GeckoEntityChairRenderer geckoEntityChairRenderer;

    public EntityChairRenderer(class_5617.class_5618 rendererManager) {
        super(rendererManager, new BedrockModel<>(), 0);
        this.geckoEntityChairRenderer = new GeckoEntityChairRenderer(rendererManager);
    }

    @Override
    public void render(EntityChair chair, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        class_746 player = class_310.method_1551().field_1724;
        if (canShowHitBox(player) && renderHitBox) {
            renderHitBox(chair, poseStack, bufferIn);
        } else {
            renderChair(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        }
    }

    private boolean canShowHitBox(@Nullable class_1657 player) {
        if (player != null && player.method_5715()) {
            return player.method_6047().method_7909() == InitItems.CHAIR_SHOW;
        }
        return false;
    }

    private void renderHitBox(EntityChair chair, class_4587 poseStack, class_4597 bufferIn) {
        class_238 aabb = chair.method_5829().method_989(-chair.method_23317(), -chair.method_23318(), -chair.method_23321());
        class_761.method_22982(poseStack, bufferIn.getBuffer(class_1921.method_23594()), aabb, 1.0F, 0, 0, 1.0F);
    }

    private void renderChair(EntityChair chair, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        // 读取默认模型，用于清除不存在模型的缓存残留
        CustomPackLoader.CHAIR_MODELS.getModel(DEFAULT_CHAIR_ID).ifPresent(model -> this.field_4737 = model);
        CustomPackLoader.CHAIR_MODELS.getInfo(DEFAULT_CHAIR_ID).ifPresent(info -> this.chairInfo = info);
        this.chairAnimations = null;

        // 通过模型 id 获取对应数据
        CustomPackLoader.CHAIR_MODELS.getModel(chair.getModelId()).ifPresent(model -> this.field_4737 = model);
        CustomPackLoader.CHAIR_MODELS.getInfo(chair.getModelId()).ifPresent(info -> this.chairInfo = info);
        CustomPackLoader.CHAIR_MODELS.getAnimation(chair.getModelId()).ifPresent(animations -> this.chairAnimations = animations);

        // GeckoLib 接管渲染
        if (this.chairInfo.isGeckoModel()) {
            this.geckoEntityChairRenderer.setMainInfo(this.chairInfo);
            this.geckoEntityChairRenderer.getAnimatableEntity(chair).setChair(this.chairInfo);
            this.geckoEntityChairRenderer.method_4054(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }

        // 模型动画设置
        this.field_4737.setAnimations(this.chairAnimations);

        GlWrapper.setPoseStack(poseStack);
        super.method_4054(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    @Override
    protected void scale(EntityChair chair, class_4587 poseStack, float partialTickTime) {
        float scale = chairInfo.getRenderEntityScale();
        poseStack.method_22905(scale, scale, scale);
    }

    @Override
    public class_2960 getTextureLocation(EntityChair entity) {
        if (chairInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return chairInfo.getTexture();
    }

    @Override
    protected void setupRotations(EntityChair chair, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180 - rotationYaw));
    }

    @Override
    protected boolean shouldShowName(EntityChair entity) {
        return entity.method_5733();
    }
}
