package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunClientUtil;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.TacCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5150;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class GeckoLayerMaidBackItem<T extends class_1308, R extends IGeoEntityRenderer<T>> extends GeoLayerRenderer<T, R> {
    public GeckoLayerMaidBackItem(R entityRendererIn) {
        super(entityRendererIn);
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBackItem<>(entityRendererIn);
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        var model = this.getLocationModel(entity);
        if (model == null) {
            return;
        }
        class_1799 stack = maid.getBackpackShowItem();
        if (!this.getGeoEntity(entity).getMaidInfo().isShowBackpack() || entity.method_6113() || entity.method_5767() || RenderFixer.isCarryOnRender(stack, buffer)) {
            return;
        }
        if (entity instanceof EntityMaid entityMaid && !entityMaid.getConfigManager().isShowBackItem()) {
            return;
        }
        if (stack.method_7909() instanceof class_5150) {
            matrixStack.method_22903();

            if (!model.backpackBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(matrixStack, model.backpackBones());
            }
            matrixStack.method_22904(0, 1, 0.25);

            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0F));
            matrixStack.method_22904(0, 0.5, -0.25);
            if (entity instanceof EntityMaid entityMaid && entityMaid.getConfigManager().isShowBackpack()) {
                maid.getMaidBackpackType().offsetBackpackItem(matrixStack);
            } else {
                BackpackManager.getEmptyBackpack().offsetBackpackItem(matrixStack);
            }
            if (SlashBladeCompat.isSlashBladeItem(stack)) {
                SlashBladeRender.renderGeckoMaidBackSlashBlade(matrixStack, buffer, packedLight, stack);
            } else {
                class_310.method_1551().method_1480().method_23177(entity, stack, class_811.field_4319, false, matrixStack, buffer, entity.method_37908(), packedLight, class_4608.field_21444, entity.method_5628());
            }
            matrixStack.method_22909();
            return;
        }


        // 背部枪械渲染
        GunClientUtil.renderBackGun(stack, model, maid, matrixStack, buffer, packedLight);
    }
}