package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.decoder.GifDecoder;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class GifTexture extends SizeTexture implements class_1061 {
    private final class_2960 texturePath;
    private class_1011[] frames;
    private int[] frameDelays;
    private int currentFrame = 0;
    private int currentFrameDelay = 0;
    private int width = 16;
    private int height = 16;

    public GifTexture(class_2960 texturePath) {
        this.texturePath = texturePath;
    }

    @Override
    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> doLoad(manager));
        } else {
            this.doLoad(manager);
        }
    }

    @SuppressWarnings("all")
    private void doLoad(class_3300 manager) {
        try (InputStream stream = manager.open(this.texturePath)) {
            GifDecoder decoder = new GifDecoder();
            decoder.read(stream);

            int totalFrames = decoder.getFrameCount();
            Dimension frameSize = decoder.getFrameSize();
            this.frames = new class_1011[totalFrames];
            this.frameDelays = new int[totalFrames];
            this.width = frameSize.width;
            this.height = frameSize.height;

            // 让图片学习原版序列帧竖向排列
            for (int i = 0; i < totalFrames; i++) {
                class_1011 nativeImage = new class_1011(this.width, this.height, true);
                BufferedImage image = decoder.getFrame(i);
                for (int y = 0; y < image.getHeight(); y++) {
                    for (int x = 0; x < image.getWidth(); x++) {
                        int argb = image.getRGB(x, y);
                        int a = (argb >> 24) & 0xFF;
                        int r = (argb >> 16) & 0xFF;
                        int g = (argb >> 8) & 0xFF;
                        int b = argb & 0xFF;

                        nativeImage.method_4305(x, y, (a << 24) | (b << 16) | (g << 8) | r);
                    }
                }
                this.frames[i] = nativeImage;
                this.frameDelays[i] = Math.max(decoder.getDelay(i) / 50, 1);
            }
            // 上传第一帧
            TextureUtil.prepareImage(this.method_4624(), 0, width, height);
            this.frames[0].method_22619(0, 0, 0, 0, 0,
                    width, height, false, false, false, false);
        } catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to load gif texture: {}", this.texturePath, e);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isExist() {
        return true;
    }

    @Override
    public void method_4622() {
        if (frames == null || frames.length == 0) {
            return;
        }
        currentFrameDelay++;
        if (currentFrameDelay >= frameDelays[currentFrame]) {
            currentFrameDelay = 0;
            currentFrame = (currentFrame + 1) % frames.length;
            TextureUtil.prepareImage(this.method_4624(), 0, width, height);
            frames[currentFrame].method_4312(0, 0, 0, 0, 0,
                    width, height, false, false);
        }
    }
}