package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ZipPackTexture extends SizeTexture {
    private final class_2960 texturePath;
    private final Path zipFilePath;
    private int width = 16;
    private int height = 16;

    public ZipPackTexture(String zipFilePath, class_2960 texturePath) {
        this.zipFilePath = Paths.get(zipFilePath);
        this.texturePath = texturePath;
    }

    @Override
    public boolean isExist() {
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile())) {
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", texturePath.method_12836(), texturePath.method_12832()));
            return entry != null;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void method_4625(class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        try (ZipFile zipFile = new ZipFile(zipFilePath.toFile())) {
            ZipEntry entry = zipFile.getEntry(String.format("assets/%s/%s", texturePath.method_12836(), texturePath.method_12832()));
            if (entry == null) {
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry)) {
                class_1011 imageIn = class_1011.method_4309(stream);
                width = imageIn.method_4307();
                height = imageIn.method_4323();
                TextureUtil.prepareImage(this.method_4624(), 0, width, height);
                imageIn.method_22619(0, 0, 0, 0, 0, width, height, false, false, false, true);
            } catch (IOException e) {
                e.printStackTrace();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }
}
