package com.github.tartaricacid.touhoulittlemaid.client.resource.models;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.model.PlayerMaidModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1068;
import net.minecraft.class_1308;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.*;

@Environment(EnvType.CLIENT)
public final class PlayerMaidModels {
    private static final Cache<String, GameProfile> GAME_PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30, TimeUnit.MINUTES).build();
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1, TimeUnit.MINUTES, new LinkedBlockingQueue<>());
    private static final GameProfile EMPTY_GAME_PROFILE = new GameProfile(null, "EMPTY");
    private static final PlayerMaidModel PLAYER_MAID_MODEL = new PlayerMaidModel(false);
    private static final PlayerMaidModel PLAYER_MAID_MODEL_SLIM = new PlayerMaidModel(true);
    private static final String SLIM_NAME = "slim";
    private static final List<class_2960> PLAYER_MAID_ANIMATION_RES = Lists.newArrayList(
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/default/head/default.js"),
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/default/head/beg.js"),
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/default/leg/default.js"),
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/player/arm/default.js"),
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/default/arm/swing.js"),
            new class_2960(TouhouLittleMaid.MOD_ID, "animation/maid/player/sit/default.js")
    );
    private static final class_2960 TEXTURE_ALEX = new class_2960("textures/entity/alex.png");
    private static final List<Object> PLAYER_MAID_ANIMATIONS = Lists.newArrayList();
    private static MaidModelInfo playerMaidInfo;
    private static class_2960 playerSkin;

    public static void reload() {
        PLAYER_MAID_ANIMATIONS.clear();
        for (class_2960 res : PLAYER_MAID_ANIMATION_RES) {
            PLAYER_MAID_ANIMATIONS.add(InnerAnimation.get(res));
        }
        playerMaidInfo = new MaidModelInfo() {
            @Override
            public class_2960 getTexture() {
                return playerSkin;
            }
        };
    }

    public static BedrockModel<class_1308> getPlayerMaidModel(String name) {
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();

        try {
            newProfile = GAME_PROFILE_CACHE.get(name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    class_2631.method_11335(profile, profileNew -> {
                        if (profileNew != null) {
                            GAME_PROFILE_CACHE.put(name, profileNew);
                        }
                    });
                });
                return EMPTY_GAME_PROFILE;
            });
        } catch (ExecutionException ignore) {
        }

        if (newProfile != null) {
            Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = minecraft.method_1582().method_4654(newProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                String skinModel = map.get(MinecraftProfileTexture.Type.SKIN).getMetadata("model");
                if (SLIM_NAME.equals(skinModel)) {
                    return PLAYER_MAID_MODEL_SLIM;
                }
            } else {
                UUID uuid = class_4844.method_43343(newProfile);
                String skinModel = class_1068.method_4647(uuid);
                if (SLIM_NAME.equals(skinModel)) {
                    return PLAYER_MAID_MODEL_SLIM;
                }
            }
        }
        return PLAYER_MAID_MODEL;
    }

    public static List<Object> getPlayerMaidAnimations() {
        return PLAYER_MAID_ANIMATIONS;
    }

    public static MaidModelInfo getPlayerMaidInfo(String name) {
        playerSkin = getPlayerSkin(name);
        return playerMaidInfo;
    }

    public static class_2960 getPlayerSkin(String name) {
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();

        try {
            newProfile = GAME_PROFILE_CACHE.get(name, () -> {
                THREAD_POOL.submit(() -> {
                    GameProfile profile = new GameProfile(null, name);
                    class_2631.method_11335(profile, profileNew -> {
                        if (profileNew != null) {
                            GAME_PROFILE_CACHE.put(name, profileNew);
                        }
                    });
                });
                return EMPTY_GAME_PROFILE;
            });
        } catch (ExecutionException ignore) {
        }

        if (newProfile != null) {
            Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = minecraft.method_1582().method_4654(newProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return minecraft.method_1582().method_4656(map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            } else {
                UUID uuid = class_4844.method_43343(newProfile);
                return class_1068.method_4648(uuid);
            }
        }

        return TEXTURE_ALEX;
    }
}
