package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

import static com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip.*;

public class ClientBoardStateTooltip implements class_5684 {
    private static final class_2960 GOMOKU_BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/gomoku.png");
    private static final class_2960 XIANGQI_BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/xiangqi.png");
    private static final class_2960 CHESS_BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/chess.png");

    private static final BiFunction<String, String, Object> CACHE = class_156.method_34865(ClientBoardStateTooltip::getBoardGameData);

    private final String type;
    private final Object boardGameData;

    public ClientBoardStateTooltip(BoardStateTooltip tooltip) {
        this.boardGameData = CACHE.apply(tooltip.type(), tooltip.stateData());
        this.type = tooltip.type();
    }

    @Nullable
    private static Cloneable getBoardGameData(String type, String stateData) {
        switch (type) {
            case GOMOKU -> {
                return GomokuCodec.decode(stateData).board();
            }
            case XIANGQI -> {
                // java 笑笑传之，没有别名功能
                com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position position = new com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position();
                position.fromFen(stateData);
                return position.squares;
            }
            case CHESS -> {
                // java 笑笑传之，没有别名功能
                com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position position = new com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position();
                position.fromFen(stateData);
                return position.squares;
            }
        }
        return null;
    }

    @Override
    public int method_32661() {
        if (boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case GOMOKU -> 80;
            case XIANGQI -> 132;
            case CHESS -> 108;
            default -> 0;
        };
    }

    @Override
    public int method_32664(class_327 font) {
        if (boardGameData == null) {
            return 0;
        }
        return switch (this.type) {
            case GOMOKU -> 76;
            case XIANGQI -> 128;
            case CHESS -> 102;
            default -> 0;
        };
    }

    @Override
    public void method_32666(class_327 font, int pX, int pY, class_332 graphics) {
        if (boardGameData == null) {
            return;
        }

        if (this.type.equals(GOMOKU) && boardGameData instanceof int[][] data) {
            this.renderGomoku(pX, pY, graphics, data);
            return;
        }

        if (this.type.equals(XIANGQI) && boardGameData instanceof byte[] data) {
            this.renderXiangqi(pX, pY, graphics, data);
            return;
        }

        if (this.type.equals(CHESS) && boardGameData instanceof byte[] chessData) {
            this.renderChess(pX, pY, graphics, chessData);
        }
    }

    private void renderGomoku(int pX, int pY, class_332 graphics, int[][] data) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1);
        graphics.method_51448().method_46416(pX, pY, 0);
        graphics.method_25302(GOMOKU_BG, pX, pY, 0, 0, 151, 151);

        for (int y = 0; y <= 14; y++) {
            for (int x = 0; x <= 14; x++) {
                int piecesIndex = data[x][y];

                int v;
                int u;
                if (piecesIndex == Point.BLACK) {
                    v = 151;
                } else if (piecesIndex == Point.WHITE) {
                    v = 160;
                } else {
                    continue;
                }

                int offsetX = pX + 1 + x * 10;
                int offsetY = pY + 1 + y * 10;

                graphics.method_25302(GOMOKU_BG, offsetX, offsetY, 0, v, 9, 9);
            }
        }

        graphics.method_51448().method_22909();
    }

    private void renderXiangqi(int pX, int pY, class_332 graphics, byte[] data) {
        graphics.method_25302(XIANGQI_BG, pX, pY, 0, 0, 128, 126);

        for (int y = 3; y <= 12; y++) {
            for (int x = 3; x <= 11; x++) {
                byte piecesIndex = CChessUtil.piecesIndex(x, y, data);

                int v;
                int u;
                if (CChessUtil.isRed(piecesIndex)) {
                    v = 126;
                    u = (piecesIndex - 8) * 11;
                } else if (CChessUtil.isBlack(piecesIndex)) {
                    v = 137;
                    u = (piecesIndex - 16) * 11;
                } else {
                    continue;
                }

                int offsetX = pX - 1 + (x - 3) * 13;
                int offsetY = pY - 1 + (y - 3) * 13;

                graphics.method_25302(XIANGQI_BG, offsetX, offsetY, u, v, 11, 11);
            }
        }
    }

    private void renderChess(int pX, int pY, class_332 graphics, byte[] data) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1);
        graphics.method_51448().method_46416(pX, pY, 0);
        graphics.method_25302(CHESS_BG, pX, pY, 0, 0, 204, 204);

        for (int y = 0; y <= 7; y++) {
            for (int x = 4; x <= 11; x++) {
                byte piecesIndex = WChessUtil.piecesIndex(x, y, data);

                int v;
                int u;
                if (WChessUtil.isWhite(piecesIndex)) {
                    v = 204;
                    u = (piecesIndex - 8) * 24;
                } else if (WChessUtil.isBlack(piecesIndex)) {
                    v = 228;
                    u = (piecesIndex - 16) * 24;
                } else {
                    continue;
                }

                int offsetX = pX + 6 + (x - 4) * 24;
                int offsetY = pY + 6 + y * 24;

                graphics.method_25302(CHESS_BG, offsetX, offsetY, u, v, 24, 24);
            }
        }

        graphics.method_51448().method_22909();
    }
}