package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2561;

public class MaidCommand {
    private static final String MAID_NAME = "maid";
    private static final String TARGETS_NAME = "targets";

    private static final String NO_AI_NAME = "no_ai";
    private static final String XP = "xp";

    private static final String RESULT_NAME = "result";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> pack = class_2170.method_9247(MAID_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> targets = class_2170.method_9244(TARGETS_NAME, class_2186.method_9309());

        LiteralArgumentBuilder<class_2168> noAi = class_2170.method_9247(NO_AI_NAME);
        LiteralArgumentBuilder<class_2168> xp = class_2170.method_9247(XP);

        RequiredArgumentBuilder<class_2168, Boolean> booleanResult = class_2170.method_9244(RESULT_NAME, BoolArgumentType.bool());
        RequiredArgumentBuilder<class_2168, Integer> intResult = class_2170.method_9244(RESULT_NAME, IntegerArgumentType.integer());

        pack.then(targets.then(noAi.then(booleanResult.executes(MaidCommand::handleMaidNoAi))));
        pack.then(targets.then(xp.then(intResult.executes(MaidCommand::handleMaidXp))));

        return pack;
    }

    private static int handleMaidNoAi(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, TARGETS_NAME);
        boolean noAi = BoolArgumentType.getBool(context, RESULT_NAME);
        if (entity instanceof EntityMaid maid) {
            maid.method_5977(noAi);
            context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.maid.no_ai.success", String.valueOf(noAi)), true);
        } else {
            context.getSource().method_9213(class_2561.method_43471("commands.touhou_little_maid.maid.not_maid"));
        }
        return Command.SINGLE_SUCCESS;
    }

    private static int handleMaidXp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 entity = class_2186.method_9313(context, TARGETS_NAME);
        int xpCount = IntegerArgumentType.getInteger(context, RESULT_NAME);
        if (entity instanceof EntityMaid maid) {
            maid.setExperience(xpCount);
            context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.maid.xp.success", String.valueOf(xpCount)), true);
        } else {
            context.getSource().method_9213(class_2561.method_43471("commands.touhou_little_maid.maid.not_maid"));
        }
        return Command.SINGLE_SUCCESS;
    }
}