package com.github.tartaricacid.touhoulittlemaid.compat.carryon;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_4597;

public class RenderFixer {
    private static final String CARRY_ON_ID = "carryon";

    /**
     * 修复 Carry On 模组渲染附魔物品时的 BUG
     * 当 fixedBuffers 为 5 时，就是 Carry On 模组的渲染器，此时禁止渲染手部物品
     */
    public static boolean isCarryOnRender(class_1799 stack, class_4597 bufferSource) {
        if (stack.method_7958() && FabricLoader.getInstance().isModLoaded(CARRY_ON_ID) && bufferSource instanceof class_4597.class_4598 buffer) {
            return buffer.field_20953.size() == 5;
        }
        return false;
    }
}
