package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai;

import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class GunAttackStrafingTask extends class_4097<EntityMaid> {
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public GunAttackStrafingTask() {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18457,
                        class_4140.field_18446, class_4141.field_18458,
                        class_4140.field_22355, class_4141.field_18456,
                        class_4140.field_18442, class_4141.field_18456),
                1200);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        class_1799 item = owner.method_6047();
        return GunCommonUtil.isGun(item) && owner.method_18868().method_18904(class_4140.field_22355)
                .filter(class_1297::method_5805)
                .isPresent();
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        class_1799 stack = owner.method_6047();
        if (!GunCommonUtil.isGun(stack)) {
            return;
        }
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            double distance = owner.method_5739(target);
            float maxAttackDistance = owner.method_18413();

            // 如果在最大攻击距离（128）之内，而且看见的时长足够长
            if (distance < owner.searchRadius()) {
                ++this.strafingTime;
            } else {
                this.strafingTime = -1;
            }

            // 如果攻击时间也足够长，随机对走位方向和前后走位进行反转
            if (this.strafingTime >= 20) {
                if (owner.method_6051().method_43057() < 0.3) {
                    this.strafingClockwise = !this.strafingClockwise;
                }
                if (owner.method_6051().method_43057() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }

            // 如果攻击时间大于 -1
            if (this.strafingTime > -1) {
                // 依据距离远近决定是否前后走位
                if (distance > maxAttackDistance * 0.65) {
                    this.strafingBackwards = false;
                } else if (distance < maxAttackDistance * 0.6) {
                    this.strafingBackwards = true;
                }

                // 应用走位，但需要考虑玩家位置
                if (!owner.method_18410() && owner.method_35057() instanceof class_1657 player && owner.method_5739(player) >= maxAttackDistance) {
                    this.stopInPlace(owner);
                } else {
                    owner.method_5962().method_6243(this.strafingBackwards ? -0.4F : 0.4F, this.strafingClockwise ? 0.2F : -0.2F);
                }
                owner.method_36456(class_3532.method_20306(owner.method_36454(), owner.field_6241, 0.0F));
                class_4215.method_19554(owner, target);
            } else {
                // 否则只朝向攻击目标
                class_4215.method_19554(owner, target);
            }
        });
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.method_5962().method_6243(0, 0);
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }

    private void stopInPlace(EntityMaid maid) {
        maid.method_5942().method_6340();
        maid.method_5938(0.0F);
        maid.method_5976(0.0F);
        maid.method_6125(0.0F);
    }
}
