package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4215;
import java.util.Locale;
import java.util.Optional;

import static com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask.targetConditionsTest;

public class TacInnerCompat {
    @Nullable
    static class_2960 getGunId(class_1799 stack) {
        IGun iGun = IGun.getIGunOrNull(stack);
        if (iGun != null) {
            return iGun.getGunId(stack);
        }
        return null;
    }

    static boolean isGun(class_1799 itemStack) {
        return itemStack.method_7909() instanceof IGun;
    }

    static boolean canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull(handItem);
        if (iGun == null) {
            return class_4215.method_24565(maid, target);
        }
        class_2960 gunId = iGun.getGunId(handItem);
        return TimelessAPI.getCommonGunIndex(gunId).map(index -> {
            String type = index.getType();
            // 狙击枪？用远距离模式
            String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
            if (sniper.equals(type)) {
                return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            }
            // 霰弹枪？手枪？冲锋枪？近距离模式
            String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
            String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
            String smg = GunTabType.SMG.name().toLowerCase(Locale.ENGLISH);
            if (shotgun.equals(type) || pistol.equals(type) || smg.equals(type)) {
                return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
            }
            // 其他情况，中等距离
            return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
        }).orElse(class_4215.method_24565(maid, target));
    }

    static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return 100;
        }
        class_2960 gunId = iGun.getGunId(gunItem);
        Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(gunId);
        if (optional.isEmpty()) {
            return 100;
        }
        CommonGunIndex gunIndex = optional.get();
        GunData gunData = gunIndex.getGunData();

        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();

        float yaw = (float) -Math.toDegrees(Math.atan2(x, z));
        float pitch = (float) -Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z)));

        float radius = shooter.method_18413();

        IGunOperator gunOperator = IGunOperator.fromLivingEntity(shooter);
        ShootResult result = gunOperator.shoot(() -> pitch, () -> yaw);

        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            return 100;
        }

        // 如果是狙击枪，应用瞄准
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            // 多加 2 tick，用来平衡延迟
            return Math.round(gunData.getAimTime() * 20) + 2;
        }

        // 如果是非狙击枪，超出 radius 范围，那么也瞄准
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.method_5739(target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                // 多加 2 tick，用来平衡延迟
                return Math.round(gunData.getAimTime() * 20) + 2;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                // 多加 2 tick，用来平衡延迟
                return Math.round(gunData.getAimTime() * 20) + 2;
            }
        }

        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(shooter::method_6047);
            // 多加 2 tick，用来平衡延迟
            return Math.round(gunData.getDrawTime() * 20) + 2;
        }

        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            return Math.round(gunData.getBoltActionTime() * 20) + 2;
        }

        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            return Math.round(emptyTime * 20) + 2;
        }

        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            return 10 + shooter.method_6051().method_43048(5);
        }

        return 2;
    }

    static void stopAim(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity(maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}