package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.google.common.collect.Lists;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.*;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public enum PicnicMatProvider implements IServerExtensionProvider<Object, class_1799>, IClientExtensionProvider<class_1799, ItemView> {
    INSTANCE;

    private static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "picnic_mat");

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> list) {
        return ClientViewGroup.map(list, ItemView::new, null);
    }

    @Override
    public @Nullable List<ViewGroup<class_1799>> getGroups(class_3222 player, class_3218 world, Object target, boolean showDetails) {
        if (target instanceof TileEntityPicnicMat picnicMat) {
            if (world.method_8321(picnicMat.getCenterPos()) instanceof TileEntityPicnicMat picnicMatCenter) {
                ItemStackHandler handler = picnicMatCenter.getHandler();
                List<class_1799> list = Lists.newArrayList();
                for (int i = 0; i < handler.getSlots(); i++) {
                    class_1799 stack = handler.getStackInSlot(i);
                    list.add(stack.method_7972());
                }
                return List.of(new ViewGroup<>(list));
            }
        }
        return null;
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }
}