package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum ShrineLampProvider implements IBlockComponentProvider {
    INSTANCE;

    private static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "shrine_lamp");

    @Override
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getBlockEntity() instanceof TileEntityMaidBeacon lamp) {
            float storagePower = lamp.getStoragePower();
            float costPower = lamp.getEffectCost() * 900;
            iTooltip.add(class_2561.method_43469("tooltips.touhou_little_maid.maid_beacon.desc", ItemMaidBeacon.DECIMAL_FORMAT.format(storagePower)));
            if (lamp.getPotionIndex() == -1) {
                iTooltip.add(class_2561.method_43469("gui.touhou_little_maid.maid_beacon.cost_power", ItemMaidBeacon.DECIMAL_FORMAT.format(0)));
            } else {
                iTooltip.add(class_2561.method_43469("gui.touhou_little_maid.maid_beacon.cost_power", ItemMaidBeacon.DECIMAL_FORMAT.format(costPower)));
            }
        }
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }
}