package com.github.tartaricacid.touhoulittlemaid.compat.slashblade;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskAttack;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class SlashBladeCompat {
    private static final String SLASH_BLADE = "slashblade";

    public static boolean isSlashBladeLoaded() {
        return FabricLoader.getInstance().isModLoaded(SLASH_BLADE);
    }

    public static boolean isSlashBladeItem(class_1799 stack) {
        return isSlashBladeLoaded() && stack.method_7909() instanceof ItemSlashBlade;
    }

    public static void swingSlashBlade(EntityMaid maid, class_1799 itemInHand) {
        if (SlashBladeCompat.isSlashBladeItem(itemInHand) && maid.getTask().getUid().equals(TaskAttack.UID)) {
            int roll = maid.method_6051().method_43048(60) - 30;
            AttackManager.doSlash(maid, roll, class_243.field_1353, false, false, 1.0, KnockBacks.smash);
            CapabilitySlashBlade.BLADESTATE.maybeGet(itemInHand).ifPresent(
                    bladeState -> bladeState.setLastActionTime(maid.field_6002.method_8510()));
        }
    }
}