package com.github.tartaricacid.touhoulittlemaid.data;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

@SuppressWarnings("UnstableApiUsage")
public class ChatTokensAttachment {
    public static final Codec<ChatTokensAttachment> CODEC = RecordCodecBuilder.create(ins -> ins.group(Codec.INT.fieldOf("num")
            .forGetter(o -> o.num)).apply(ins, ChatTokensAttachment::new));
    public static final AttachmentType<ChatTokensAttachment> TYPE = AttachmentRegistry.<ChatTokensAttachment>builder()
            .initializer(() -> new ChatTokensAttachment(0))
            .copyOnDeath()
            .persistent(CODEC)
            .buildAndRegister(new class_2960(TouhouLittleMaid.MOD_ID, "chat_tokens"));
    private int num;

    public ChatTokensAttachment(int num) {
        this.num = num;
    }

    public boolean canAdd() {
        return this.num + 1 <= getMaxNum();
    }

    public void add(int num) {
        if (num + this.num <= getMaxNum()) {
            this.num += num;
        } else {
            this.num = getMaxNum();
        }
    }

    public void min(int num) {
        if (num <= this.num) {
            this.num -= num;
        } else {
            this.num = 0;
        }
    }

    public void set(int num) {
        this.num = class_3532.method_15340(num, 0, getMaxNum());
    }

    public int getMaxNum() {
        return AIConfig.MAX_TOKENS_PER_PLAYER.get();
    }

    public int get() {
        return this.num;
    }
}