package com.github.tartaricacid.touhoulittlemaid.datapack.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.KaomojiData;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7367;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class KaomojiDataReloadListener implements class_4013, IdentifiableResourceReloadListener {
    private static final class_2960 FILE_PATH = new class_2960(TouhouLittleMaid.MOD_ID, "chat_bubble/kaomoji.json");
    private static final Gson GSON = new Gson();

    private static final class_2960 ID = new class_2960(TouhouLittleMaid.MOD_ID, "kaomoji_reload");

    @Override
    public void method_14491(class_3300 resourceManager) {
        // 先清除旧数据
        KaomojiData.clear();
        // 再逐层读取新数据，进行合并加载
        resourceManager.method_29213().forEach(packResources -> {
            class_7367<InputStream> resource = packResources.method_14405(class_3264.field_14190, FILE_PATH);
            if (resource == null) {
                return;
            }
            try (InputStream inputStream = resource.get(); InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8)) {
                Map<String, List<String>> data = GSON.fromJson(reader, new TypeToken<Map<String, List<String>>>() {
                }.getType());
                if (data != null && !data.isEmpty()) {
                    KaomojiData.merge(data);
                }
            } catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to load kaomoji data from {}", FILE_PATH, e);
            }
        });
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
