package com.github.tartaricacid.touhoulittlemaid.debug.target;

import cn.sh1rocu.touhoulittlemaid.api.event.PlayerTickEvent;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import net.minecraft.class_5996;
import java.util.List;

@class_5996
public class SendMaidDebugDataEvent {
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!TouhouLittleMaid.DEBUG) {
            return;
        }
        if (event.getEntity().field_6002.field_9236 || !(event.getEntity() instanceof class_3222 serverPlayer)) {
            return;
        }
        // 每 4 tick 发送一次数据
        if (serverPlayer.field_6012 % 4 == 0) {
            List<EntityMaid> debuggingMaid = DebugMaidManager.getDebuggingMaid(serverPlayer);
            for (EntityMaid maid : debuggingMaid) {
                renderForMaid(maid, serverPlayer);
            }
        }
    }

    private static void renderForMaid(@Nullable EntityMaid maid, class_3222 player) {
        if (maid == null) {
            return;
        }

        if (!maid.method_5942().method_6357()) {
            class_11 path = maid.method_5942().method_6345();
            if (path != null) {
                class_2540 byteBuf = new class_2540(Unpooled.buffer());
                byteBuf.writeInt(maid.method_5628());
                byteBuf.writeFloat(0.5f);
                path.method_35498(byteBuf);
                player.field_13987.method_14364(new class_2658(class_2658.field_12161, byteBuf));
            }
        }

        DebugMaidManager.getDebugTargets(maid).forEach(target -> {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10807(target.pos());
            byteBuf.writeInt(target.color());
            byteBuf.method_10814(target.text());
            byteBuf.writeInt(target.lifeTime());
            player.field_13987.method_14364(new class_2658(class_2658.field_20599, byteBuf));
        });
    }
}